/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.util.concurrent.AbstractFuture;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;

abstract class TimingOutInvocationCallback
extends AbstractFuture<Response>
implements InvocationCallback {
    private static final Logger logger = Logger.getLogger(TimingOutInvocationCallback.class.getName());
    private static final Timer TIMER = new Timer("Jersey application request timer");
    private final Object suspendLock = new Object();
    private final AtomicBoolean done = new AtomicBoolean(false);
    private InvocationContext invocationCtx = null;
    private TimerTask timeoutTask = null;

    TimingOutInvocationCallback() {
    }

    public void result(Response response) {
        if (this.done.compareAndSet(false, true)) {
            this.set(this.handleResponse(response));
        }
    }

    protected abstract Response handleResponse(Response var1);

    public void failure(Throwable exception) {
        if (this.done.compareAndSet(false, true)) {
            this.set(this.handleFailure(exception));
        }
    }

    protected abstract Response handleFailure(Throwable var1);

    public void cancelled() {
        if (this.done.compareAndSet(false, true)) {
            this.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspended(long time, TimeUnit unit, InvocationContext context) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (TimingOutInvocationCallback.this.done.compareAndSet(false, true)) {
                    TimingOutInvocationCallback.this.set(TimingOutInvocationCallback.this.handleTimeout(TimingOutInvocationCallback.this.invocationCtx));
                }
            }
        };
        Object object = this.suspendLock;
        synchronized (object) {
            if (this.invocationCtx != null) {
                throw new IllegalStateException("Already suspended");
            }
            this.invocationCtx = context;
            if (time <= 0L) {
                return;
            }
            this.timeoutTask = task;
        }
        try {
            TIMER.schedule(task, unit.toMillis(time));
        }
        catch (IllegalStateException ex) {
            logger.log(Level.WARNING, "Error while scheduling a timeout task.", ex);
        }
    }

    protected abstract Response handleTimeout(InvocationContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendTimeoutChanged(long time, TimeUnit unit) {
        if (!this.done.get()) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (TimingOutInvocationCallback.this.done.compareAndSet(false, true)) {
                        TimingOutInvocationCallback.this.set(TimingOutInvocationCallback.this.handleTimeout(TimingOutInvocationCallback.this.invocationCtx));
                    }
                }
            };
            Object object = this.suspendLock;
            synchronized (object) {
                if (this.timeoutTask != null) {
                    this.timeoutTask.cancel();
                }
                this.timeoutTask = task;
            }
            try {
                TIMER.schedule(task, unit.toMillis(time));
            }
            catch (IllegalStateException ex) {
                logger.log(Level.WARNING, "Error while scheduling a timeout task.", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumed() {
        Object object = this.suspendLock;
        synchronized (object) {
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel();
            }
        }
    }
}

