/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.filter;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.FilterContext;
import javax.ws.rs.ext.PreMatchRequestFilter;
import org.glassfish.jersey.message.internal.LanguageTag;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.uri.UriComponent;

public class UriConnegFilter
implements PreMatchRequestFilter {
    protected final Map<String, MediaType> mediaTypeMappings;
    protected final Map<String, String> languageMappings;
    @Context
    protected UriInfo uriInfo;

    public static void enableFor(ResourceConfig rc, Map<String, MediaType> mediaTypeMappings, Map<String, String> languageMappings) {
        rc.addClasses(UriConnegFilter.class);
        UriConnegFilter.setIfNull(rc, "jersey.config.server.mediaTypeMappings", mediaTypeMappings);
        UriConnegFilter.setIfNull(rc, "jersey.config.server.languageMappings", languageMappings);
    }

    public static void enableFor(ResourceConfig rc, String mediaTypeMappings, String languageMappings) {
        UriConnegFilter.enableFor(rc, UriConnegFilter.extractMediaTypeMappings(mediaTypeMappings), UriConnegFilter.extractLanguageMappings(languageMappings));
    }

    public UriConnegFilter(@Context ResourceConfig rc) {
        this(UriConnegFilter.extractMediaTypeMappings(rc.getProperty("jersey.config.server.mediaTypeMappings")), UriConnegFilter.extractLanguageMappings(rc.getProperty("jersey.config.server.languageMappings")));
    }

    public UriConnegFilter(Map<String, MediaType> mediaTypeMappings, Map<String, String> languageMappings) {
        if (mediaTypeMappings == null) {
            mediaTypeMappings = Collections.emptyMap();
        }
        if (languageMappings == null) {
            languageMappings = Collections.emptyMap();
        }
        this.mediaTypeMappings = mediaTypeMappings;
        this.languageMappings = languageMappings;
    }

    public void preMatchFilter(FilterContext fc) throws IOException {
        int index;
        String suffix;
        int i;
        String path = this.uriInfo.getRequestUri().getRawPath();
        if (path.indexOf(46) == -1) {
            return;
        }
        List l = this.uriInfo.getPathSegments(false);
        if (l.isEmpty()) {
            return;
        }
        PathSegment segment = null;
        for (int i2 = l.size() - 1; i2 >= 0 && (segment = (PathSegment)l.get(i2)).getPath().length() <= 0; --i2) {
        }
        if (segment == null) {
            return;
        }
        int length = path.length();
        String[] suffixes = segment.getPath().split("\\.");
        Request.RequestBuilder requestBuilder = null;
        for (i = suffixes.length - 1; i >= 1; --i) {
            MediaType accept;
            suffix = suffixes[i];
            if (suffix.length() == 0 || (accept = this.mediaTypeMappings.get(suffix)) == null) continue;
            requestBuilder = fc.getRequestBuilder();
            requestBuilder.header("Accept", null);
            requestBuilder.header("Accept", (Object)accept.toString());
            index = path.lastIndexOf('.' + suffix);
            path = new StringBuilder(path).delete(index, index + suffix.length() + 1).toString();
            suffixes[i] = "";
            break;
        }
        for (i = suffixes.length - 1; i >= 1; --i) {
            String acceptLanguage;
            suffix = suffixes[i];
            if (suffix.length() == 0 || (acceptLanguage = this.languageMappings.get(suffix)) == null) continue;
            if (requestBuilder == null) {
                requestBuilder = fc.getRequestBuilder();
            }
            requestBuilder.header("Accept-Language", null);
            requestBuilder.header("Accept-Language", (Object)acceptLanguage);
            index = path.lastIndexOf('.' + suffix);
            path = new StringBuilder(path).delete(index, index + suffix.length() + 1).toString();
            suffixes[i] = "";
            break;
        }
        if (requestBuilder != null) {
            requestBuilder.redirect(this.uriInfo.getRequestUriBuilder().replacePath(path).build(new Object[0]));
            fc.setRequest(requestBuilder.build());
        }
    }

    private static void setIfNull(ResourceConfig rc, String property, Object value) {
        if (value != null && rc.getProperty(property) == null) {
            rc.setProperty(property, value);
        }
    }

    private static Map<String, MediaType> extractMediaTypeMappings(Object mappings) {
        return UriConnegFilter.parseAndValidateMappings("jersey.config.server.mediaTypeMappings", mappings, new TypeParser<MediaType>(){

            @Override
            public MediaType valueOf(String value) {
                return MediaType.valueOf((String)value);
            }
        });
    }

    private static Map<String, String> extractLanguageMappings(Object mappings) {
        return UriConnegFilter.parseAndValidateMappings("jersey.config.server.languageMappings", mappings, new TypeParser<String>(){

            @Override
            public String valueOf(String value) {
                return LanguageTag.valueOf((String)value).toString();
            }
        });
    }

    private static <T> Map<String, T> parseAndValidateMappings(String property, Object mappings, TypeParser<T> parser) {
        if (mappings == null) {
            return Collections.emptyMap();
        }
        if (mappings instanceof Map) {
            return (Map)mappings;
        }
        HashMap mappingsMap = Maps.newHashMap();
        if (mappings instanceof String) {
            UriConnegFilter.parseMappings(property, (String)mappings, mappingsMap, parser);
        } else if (mappings instanceof String[]) {
            String[] mappingsArray = (String[])mappings;
            for (int i = 0; i < mappingsArray.length; ++i) {
                UriConnegFilter.parseMappings(property, mappingsArray[i], mappingsMap, parser);
            }
        } else {
            throw new IllegalArgumentException(LocalizationMessages.INVALID_MAPPING_TYPE(property));
        }
        UriConnegFilter.encodeKeys(mappingsMap);
        return mappingsMap;
    }

    private static <T> void parseMappings(String property, String mappings, Map<String, T> mappingsMap, TypeParser<T> parser) {
        if (mappings == null) {
            return;
        }
        String[] records = mappings.split(",");
        for (int i = 0; i < records.length; ++i) {
            String[] record = records[i].split(":");
            if (record.length != 2) {
                throw new IllegalArgumentException(LocalizationMessages.INVALID_MAPPING_FORMAT(property, mappings));
            }
            String trimmedSegment = record[0].trim();
            String trimmedValue = record[1].trim();
            if (trimmedSegment.length() == 0) {
                throw new IllegalArgumentException(LocalizationMessages.INVALID_MAPPING_KEY_EMPTY(property, records[i]));
            }
            if (trimmedValue.length() == 0) {
                throw new IllegalArgumentException(LocalizationMessages.INVALID_MAPPING_VALUE_EMPTY(property, records[i]));
            }
            mappingsMap.put(trimmedSegment, parser.valueOf(trimmedValue));
        }
    }

    private static <T> void encodeKeys(Map<String, T> map) {
        HashMap<String, T> tempMap = new HashMap<String, T>();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            tempMap.put(UriComponent.contextualEncode((String)entry.getKey(), (UriComponent.Type)UriComponent.Type.PATH_SEGMENT), entry.getValue());
        }
        map.clear();
        map.putAll(tempMap);
    }

    private static interface TypeParser<T> {
        public T valueOf(String var1);
    }
}

