/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal;

import java.util.Set;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.spi.AbstractContainerLifecycleListener;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;

public final class ConfigHelper {
    private static final ContainerLifecycleListener EMPTY_CONTAINER_LIFECYCLE_LISTENER = new AbstractContainerLifecycleListener(){};

    public static ContainerLifecycleListener getContainerLifecycleListener(ApplicationHandler applicationHandler) {
        final Set listeners = applicationHandler.getServiceProviders().getAll(ContainerLifecycleListener.class);
        return listeners.isEmpty() ? EMPTY_CONTAINER_LIFECYCLE_LISTENER : new ContainerLifecycleListener(){

            @Override
            public void onStartup(Container container) {
                for (ContainerLifecycleListener listener : listeners) {
                    listener.onStartup(container);
                }
            }

            @Override
            public void onReload(Container container) {
                for (ContainerLifecycleListener listener : listeners) {
                    listener.onReload(container);
                }
            }

            @Override
            public void onShutdown(Container container) {
                for (ContainerLifecycleListener listener : listeners) {
                    listener.onReload(container);
                }
            }
        };
    }
}

