/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.ws.rs.core.Request;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.internal.routing.SingleMatchResult;

final class MatchResultInitializerAcceptor
implements TreeAcceptor {
    private final Factory<RouterModule.RoutingContext> contextProvider;
    private final TreeAcceptor rootRoute;

    private MatchResultInitializerAcceptor(Factory<RouterModule.RoutingContext> contextProvider, TreeAcceptor rootRoute) {
        this.contextProvider = contextProvider;
        this.rootRoute = rootRoute;
    }

    public Pair<Request, Iterator<TreeAcceptor>> apply(Request request) {
        RouterModule.RoutingContext rc = (RouterModule.RoutingContext)this.contextProvider.get();
        rc.pushMatchResult(new SingleMatchResult(Requests.relativePath((Request)request, (boolean)false)));
        return Tuples.of((Object)request, (Object)Iterators.singletonIterator((Object)this.rootRoute));
    }

    class Builder {
        private final Factory<RouterModule.RoutingContext> contextProvider;

        public Builder(Factory<RouterModule.RoutingContext> contextProvider) {
            this.contextProvider = contextProvider;
        }

        public MatchResultInitializerAcceptor build(TreeAcceptor rootRoute) {
            return new MatchResultInitializerAcceptor(this.contextProvider, rootRoute);
        }
    }
}

