/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.base.Function;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import org.glassfish.hk2.ComponentException;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.TypeLiteral;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.routing.MatchResultInitializerAcceptor;
import org.glassfish.jersey.server.internal.routing.PathPatternRouteAcceptor;
import org.glassfish.jersey.server.internal.routing.PathPatternRouteBuilder;
import org.glassfish.jersey.server.internal.routing.PatternRouteAcceptor;
import org.glassfish.jersey.server.internal.routing.PatternRouteBuilder;
import org.glassfish.jersey.server.internal.routing.RedirectingAcceptor;
import org.glassfish.jersey.server.internal.routing.UriRoutingContext;
import org.glassfish.jersey.uri.ExtendedUriInfo;
import org.glassfish.jersey.uri.PathPattern;
import org.glassfish.jersey.uri.UriTemplate;
import org.jvnet.hk2.annotations.Inject;

public class RouterModule
extends AbstractModule {
    static final Function<Factory<TreeAcceptor>, TreeAcceptor> FACTORY_TO_ACCEPTOR_TRANSFORMATION = new Function<Factory<TreeAcceptor>, TreeAcceptor>(){

        public TreeAcceptor apply(Factory<TreeAcceptor> f) {
            return (TreeAcceptor)f.get();
        }
    };

    public void configure() {
        this.bind((TypeLiteral)new TypeLiteral<RootRouteBuilder<Pattern>>(){}).to(PatternRouteBuilder.class);
        this.bind((TypeLiteral)new TypeLiteral<RootRouteBuilder<PathPattern>>(){}).to(PathPatternRouteBuilder.class);
        this.bind(UriRoutingContext.class, new Class[0]).to(UriRoutingContext.class).in(RequestScope.class);
        this.bind(RoutingContext.class, new Class[0]).toFactory(UriRoutingContextFactory.class).in(RequestScope.class);
        this.bind(ExtendedUriInfo.class, new Class[0]).toFactory(UriRoutingContextFactory.class).in(RequestScope.class);
        this.bind(UriInfo.class, new Class[0]).toFactory(UriRoutingContextFactory.class).in(RequestScope.class);
        this.bind().to(MatchResultInitializerAcceptor.Builder.class);
        this.bind().to(PatternRouteAcceptor.Builder.class);
        this.bind().to(PathPatternRouteAcceptor.Builder.class);
        this.bind().to(RedirectingAcceptor.Builder.class);
    }

    private static class UriRoutingContextFactory
    implements Factory<UriRoutingContext> {
        @Inject
        private UriRoutingContext ctx;

        private UriRoutingContextFactory() {
        }

        public UriRoutingContext get() throws ComponentException {
            return this.ctx;
        }
    }

    public static interface RouteToPathBuilder<T>
    extends RouteBuilder<T>,
    RouteToBuilder<T>,
    TreeAcceptor.Builder {
    }

    public static interface RouteToBuilder<T> {
        public RouteToPathBuilder<T> to(TreeAcceptor.Builder var1);

        public RouteToPathBuilder<T> to(TreeAcceptor var1);

        public RouteToPathBuilder<T> to(Class<? extends TreeAcceptor> var1);

        public RouteToPathBuilder<T> to(Factory<? extends TreeAcceptor> var1);
    }

    public static interface RouteBuilder<T> {
        public RouteToBuilder<T> route(String var1);

        public RouteToBuilder<T> route(T var1);
    }

    public static interface RootRouteBuilder<T>
    extends RouteBuilder<T> {
        public TreeAcceptor root(TreeAcceptor var1);
    }

    public static interface RoutingContext {
        public void pushMatchResult(MatchResult var1);

        public void pushMatchedResource(Object var1);

        public Object peekMatchedResource();

        public MatchResult peekMatchResult();

        public void pushTemplate(UriTemplate var1);

        public String getFinalMatchingGroup();

        public List<MatchResult> getMatchedResults();

        public void pushLeftHandPath();

        @Nullable
        public MediaType getEffectiveAcceptableType();

        public void setEffectiveAcceptableType(@Nonnull MediaType var1) throws NullPointerException;

        public void setResponseMethodType(Type var1) throws NullPointerException;

        public Type getResponseMethodType();

        public void setResponseMethodAnnotations(Annotation[] var1) throws NullPointerException;

        public Annotation[] getResponseMethodAnnotations();
    }
}

