/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.FilterContext;
import javax.ws.rs.ext.PreMatchRequestFilter;

public class CsrfProtectionFilter
implements PreMatchRequestFilter {
    public static final String HEADER_NAME = "X-Requested-By";
    private static final Set<String> METHODS_TO_IGNORE;

    public final void preMatchFilter(FilterContext fc) throws IOException {
        Request request = fc.getRequest();
        if (!METHODS_TO_IGNORE.contains(request.getMethod()) && request.getHeaders().getHeader(HEADER_NAME) == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    static {
        HashSet<String> mti = new HashSet<String>();
        mti.add("GET");
        mti.add("OPTIONS");
        mti.add("HEAD");
        METHODS_TO_IGNORE = Collections.unmodifiableSet(mti);
    }
}

