/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.FilterContext;
import javax.ws.rs.ext.PreMatchRequestFilter;
import org.glassfish.jersey.server.ResourceConfig;

public class UriConnegFilter
implements PreMatchRequestFilter {
    public static final String PROPERTY_MEDIA_EXTENSIONS = "org.glassfish.jersey.server.filter.UriConnegFilter.mediaExtensions";
    public static final String PROPERTY_LANGUAGE_EXTENSIONS = "org.glassfish.jersey.server.filter.UriConnegFilter.languageExtensions";
    protected final Map<String, MediaType> mediaExtensions;
    protected final Map<String, String> languageExtensions;
    @Context
    protected UriInfo uriInfo;

    public static void enableFor(ResourceConfig rc, Map<String, MediaType> mediaExtensions, Map<String, String> languageExtensions) {
        rc.addClasses(UriConnegFilter.class);
        rc.setProperty(PROPERTY_MEDIA_EXTENSIONS, mediaExtensions);
        rc.setProperty(PROPERTY_LANGUAGE_EXTENSIONS, languageExtensions);
    }

    public UriConnegFilter(@Context ResourceConfig rc) {
        this((Map)rc.getProperty(PROPERTY_MEDIA_EXTENSIONS), (Map)rc.getProperty(PROPERTY_LANGUAGE_EXTENSIONS));
    }

    public UriConnegFilter(Map<String, MediaType> mediaExtensions, Map<String, String> languageExtensions) {
        if (mediaExtensions == null) {
            mediaExtensions = Collections.emptyMap();
        }
        if (languageExtensions == null) {
            languageExtensions = Collections.emptyMap();
        }
        this.mediaExtensions = mediaExtensions;
        this.languageExtensions = languageExtensions;
    }

    public void preMatchFilter(FilterContext fc) throws IOException {
        int index;
        String suffix;
        int i;
        String path = this.uriInfo.getRequestUri().getRawPath();
        if (path.indexOf(46) == -1) {
            return;
        }
        List l = this.uriInfo.getPathSegments(false);
        if (l.isEmpty()) {
            return;
        }
        PathSegment segment = null;
        for (int i2 = l.size() - 1; i2 >= 0 && (segment = (PathSegment)l.get(i2)).getPath().length() <= 0; --i2) {
        }
        if (segment == null) {
            return;
        }
        int length = path.length();
        String[] suffixes = segment.getPath().split("\\.");
        Request.RequestBuilder requestBuilder = null;
        for (i = suffixes.length - 1; i >= 1; --i) {
            MediaType accept;
            suffix = suffixes[i];
            if (suffix.length() == 0 || (accept = this.mediaExtensions.get(suffix)) == null) continue;
            requestBuilder = fc.getRequestBuilder();
            requestBuilder.header("Accept", (Object)accept.toString());
            index = path.lastIndexOf('.' + suffix);
            path = new StringBuilder(path).delete(index, index + suffix.length() + 1).toString();
            suffixes[i] = "";
            break;
        }
        for (i = suffixes.length - 1; i >= 1; --i) {
            String acceptLanguage;
            suffix = suffixes[i];
            if (suffix.length() == 0 || (acceptLanguage = this.languageExtensions.get(suffix)) == null) continue;
            if (requestBuilder == null) {
                requestBuilder = fc.getRequestBuilder();
            }
            requestBuilder.header("Accept-Language", (Object)acceptLanguage);
            index = path.lastIndexOf('.' + suffix);
            path = new StringBuilder(path).delete(index, index + suffix.length() + 1).toString();
            suffixes[i] = "";
            break;
        }
        if (requestBuilder != null) {
            requestBuilder.redirect(this.uriInfo.getRequestUriBuilder().replacePath(path).build(new Object[0]));
            fc.setRequest(requestBuilder.build());
        }
    }
}

