/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.ExtractorException;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractHttpContextValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.HttpContext;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.jvnet.hk2.annotations.Inject;

final class QueryParamValueFactoryProvider
extends AbstractValueFactoryProvider<QueryParam> {
    public QueryParamValueFactoryProvider(@Inject MultivaluedParameterExtractorProvider mpep, @Inject Injector injector) {
        super(mpep, injector, Parameter.Source.QUERY);
    }

    @Override
    public AbstractHttpContextValueFactory<?> createValueFactory(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new QueryParamValueFactory(e, !parameter.isEncoded());
    }

    private static final class QueryParamValueFactory
    extends AbstractHttpContextValueFactory<Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final boolean decode;

        QueryParamValueFactory(MultivaluedParameterExtractor<?> extractor, boolean decode) {
            this.extractor = extractor;
            this.decode = decode;
        }

        @Override
        protected Object get(HttpContext context) {
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)context.getUriInfo().getQueryParameters(this.decode));
            }
            catch (ExtractorException e) {
                throw new ParamException.QueryParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }

    static final class InjectionResolver
    extends ParamInjectionResolver<QueryParam> {
        public InjectionResolver() {
            super(QueryParam.class, QueryParamValueFactoryProvider.class);
        }
    }
}

