/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.regex.Pattern;
import org.glassfish.hk2.Services;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.routing.AbstractRouteToPathBuilder;
import org.glassfish.jersey.server.internal.routing.MatchResultInitializerAcceptor;
import org.glassfish.jersey.server.internal.routing.PatternRouteAcceptor;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.jvnet.hk2.annotations.Inject;

class PatternRouteBuilder
implements RouterModule.RootRouteBuilder<Pattern> {
    private final Services services;
    private final PatternRouteAcceptor.Builder acceptorFactory;
    private final MatchResultInitializerAcceptor.Builder initializerFactory;

    PatternRouteBuilder(@Inject Services services, @Inject PatternRouteAcceptor.Builder acceptorFactory, @Inject MatchResultInitializerAcceptor.Builder initializerFactory) {
        this.services = services;
        this.acceptorFactory = acceptorFactory;
        this.initializerFactory = initializerFactory;
    }

    @Override
    public RouterModule.RouteToBuilder<Pattern> route(String pattern) {
        return this.route(Pattern.compile(pattern));
    }

    @Override
    public RouterModule.RouteToBuilder<Pattern> route(Pattern pattern) {
        return new AbstractRouteToPathBuilder<Pattern>(this.services, pattern){

            @Override
            public RouterModule.RouteToBuilder<Pattern> route(String pattern) {
                return super.route(Pattern.compile(pattern));
            }

            @Override
            public TreeAcceptor build() {
                return PatternRouteBuilder.this.acceptorFactory.build(this.acceptedRoutes());
            }
        };
    }

    @Override
    public TreeAcceptor root(TreeAcceptor routingRoot) {
        return this.initializerFactory.build(routingRoot);
    }
}

