/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Request;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.ClassTypePair;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.model.MethodHandler;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Parameterized;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelVisitor;

public final class Invocable
implements Parameterized,
ResourceModelComponent {
    static final Method APPLY_INFLECTOR_METHOD = Invocable.initApplyMethod();
    private final MethodHandler handler;
    private final Method handlingMethod;
    private final List<Parameter> parameters;
    private final GenericType<?> responseType;

    private static Method initApplyMethod() {
        try {
            return Inflector.class.getMethod("apply", Object.class);
        }
        catch (NoSuchMethodException e) {
            IncompatibleClassChangeError error = new IncompatibleClassChangeError("Inflector.apply(Object) method not found");
            error.initCause(e);
            throw error;
        }
    }

    public static <T> Invocable create(Inflector<Request, T> inflector) {
        return new Invocable(MethodHandler.create(inflector), APPLY_INFLECTOR_METHOD, false);
    }

    public static Invocable create(Class<? extends Inflector> inflectorClass) {
        return new Invocable(MethodHandler.create(inflectorClass), APPLY_INFLECTOR_METHOD, false);
    }

    public static Invocable create(MethodHandler handler, Method handlingMethod) {
        return new Invocable(handler, handlingMethod, false);
    }

    public static Invocable create(MethodHandler handler, Method handlingMethod, boolean encodedParameters) {
        return new Invocable(handler, handlingMethod, encodedParameters);
    }

    private Invocable(MethodHandler handler, Method handlingMethod, boolean encodedParameters) {
        this.handler = handler;
        this.handlingMethod = handlingMethod;
        Class<?> handlerClass = handler.getHandlerClass();
        ClassTypePair ctPair = ReflectionHelper.resolveGenericType(handlerClass, handlingMethod.getDeclaringClass(), handlingMethod.getReturnType(), (Type)handlingMethod.getGenericReturnType());
        this.responseType = GenericType.of((Class)ctPair.rawClass(), (Type)ctPair.type());
        this.parameters = Collections.unmodifiableList(Parameter.create(handlerClass, handlingMethod.getDeclaringClass(), handlingMethod, encodedParameters));
    }

    public MethodHandler getHandler() {
        return this.handler;
    }

    public Method getHandlingMethod() {
        return this.handlingMethod;
    }

    public GenericType<?> getResponseType() {
        return this.responseType;
    }

    public boolean isInflector() {
        return APPLY_INFLECTOR_METHOD == this.handlingMethod || APPLY_INFLECTOR_METHOD.equals(this.handlingMethod);
    }

    @Override
    public boolean requiresEntity() {
        for (Parameter p : this.getParameters()) {
            if (Parameter.Source.ENTITY != p.getSource()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void accept(ResourceModelVisitor visitor) {
        visitor.visitInvocable(this);
    }

    @Override
    public List<? extends ResourceModelComponent> getComponents() {
        return Arrays.asList(this.handler);
    }

    public String toString() {
        return "Invocable{handler=" + this.handler + ", handlingMethod=" + this.handlingMethod + ", parameters=" + this.parameters + ", responseType=" + this.responseType + '}';
    }
}

