/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.LocalizationMessages;

public class ChunkedResponse<T>
extends GenericType<T>
implements Closeable {
    static final String CHUNKED_MODE = "jersey.internal.server.chunked-mode";
    private final BlockingDeque<T> queue = new LinkedBlockingDeque<T>();
    private volatile boolean closed = false;
    private boolean flushing = false;
    private volatile ContainerRequest requestContext;
    private volatile ContainerResponse responseContext;

    protected ChunkedResponse() {
    }

    public ChunkedResponse(Type chunkType) {
        super(chunkType);
    }

    public void write(T chunk) throws IOException {
        if (this.closed) {
            throw new IOException(LocalizationMessages.CHUNKED_RESPONSE_CLOSED());
        }
        if (chunk != null) {
            this.queue.add(chunk);
        }
        this.flushQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void flushQueue() throws IOException {
        block34: {
            T t;
            boolean shouldClose;
            if (this.requestContext == null || this.responseContext == null) {
                return;
            }
            Exception ex = null;
            ChunkedResponse chunkedResponse = this;
            synchronized (chunkedResponse) {
                if (this.flushing) {
                    return;
                }
                shouldClose = this.closed;
                t = this.queue.poll();
                if (t != null || shouldClose) {
                    this.flushing = true;
                }
            }
            while (t != null) {
                this.requestContext.getWorkers().writeTo(t, t.getClass(), this.getType(), this.responseContext.getEntityAnnotations(), this.responseContext.getMediaType(), this.responseContext.getHeaders(), this.requestContext.getPropertiesDelegate(), this.responseContext.getEntityStream(), null, true);
                t = this.queue.poll();
                if (t != null) continue;
                chunkedResponse = this;
                synchronized (chunkedResponse) {
                    shouldClose = this.closed;
                    t = this.queue.poll();
                    if (t == null) {
                        this.responseContext.commitStream();
                        this.flushing = shouldClose;
                        break;
                    }
                }
            }
            if (!shouldClose) break block34;
            try {
                this.responseContext.getEntityStream().close();
            }
            catch (Exception e) {
                ex = ex == null ? e : ex;
            }
            try {
                this.requestContext.getResponseWriter().commit();
            }
            catch (Exception e) {
                Exception exception = ex = ex == null ? e : ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            break block34;
            catch (Exception e) {
                try {
                    this.closed = true;
                    shouldClose = true;
                    ex = e;
                    if (!shouldClose) break block34;
                }
                catch (Throwable throwable) {
                    if (shouldClose) {
                        try {
                            this.responseContext.getEntityStream().close();
                        }
                        catch (Exception e2) {
                            ex = ex == null ? e2 : ex;
                        }
                        try {
                            this.requestContext.getResponseWriter().commit();
                        }
                        catch (Exception e3) {
                            Exception exception = ex = ex == null ? e3 : ex;
                        }
                        if (ex instanceof IOException) {
                            throw (IOException)ex;
                        }
                        if (ex instanceof RuntimeException) {
                            throw (RuntimeException)ex;
                        }
                    }
                    throw throwable;
                }
                try {
                    this.responseContext.getEntityStream().close();
                }
                catch (Exception e4) {
                    ex = ex == null ? e4 : ex;
                }
                try {
                    this.requestContext.getResponseWriter().commit();
                }
                catch (Exception e5) {
                    Exception exception = ex = ex == null ? e5 : ex;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.flushQueue();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.queue.hashCode();
    }

    public String toString() {
        return "ChunkedResponse<" + this.getType() + ">";
    }

    void setContext(ContainerRequest requestContext, ContainerResponse responseContext) throws IOException {
        this.requestContext = requestContext;
        this.responseContext = responseContext;
        this.flushQueue();
    }
}

