/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AbstractChainableStage;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.PriorityComparator;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.routing.RoutingContext;

class ContainerFilteringStage
extends AbstractChainableStage<ContainerRequest> {
    private ServiceLocator locator;
    private final List<ContainerRequestFilter> requestFilters;
    private final List<ContainerResponseFilter> responseFilters;
    private final Provider<ResponseProcessor.RespondingContext<ContainerResponse>> respondingContextFactory;

    private ContainerFilteringStage(Provider<ResponseProcessor.RespondingContext<ContainerResponse>> respondingContextFactory, ServiceLocator locator, List<ContainerRequestFilter> requestFilters, List<ContainerResponseFilter> responseFilters) {
        this.respondingContextFactory = respondingContextFactory;
        this.locator = locator;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
    }

    public Stage.Continuation<ContainerRequest> apply(ContainerRequest requestContext) {
        List<ContainerRequestFilter> sortedRequestFilters;
        if (this.responseFilters == null) {
            RoutingContext rc = (RoutingContext)this.locator.getService(RoutingContext.class, new Annotation[0]);
            sortedRequestFilters = new ArrayList<ContainerRequestFilter>(this.requestFilters);
            sortedRequestFilters.addAll(rc.getBoundRequestFilters());
            Collections.sort(sortedRequestFilters, new PriorityComparator(PriorityComparator.Order.ASCENDING));
        } else {
            ((ResponseProcessor.RespondingContext)this.respondingContextFactory.get()).push((ChainableStage)new ResponseFilterStage(this.responseFilters, this.locator));
            sortedRequestFilters = this.requestFilters;
        }
        for (ContainerRequestFilter filter : sortedRequestFilters) {
            try {
                filter.filter((ContainerRequestContext)requestContext);
                final Response abortResponse = requestContext.getAbortResponse();
                if (abortResponse == null) continue;
                return Stage.Continuation.of((Object)((Object)requestContext), (Stage)Stages.asStage((Inflector)new Inflector<ContainerRequest, ContainerResponse>(){

                    public ContainerResponse apply(ContainerRequest requestContext) {
                        return new ContainerResponse(requestContext, abortResponse);
                    }
                }));
            }
            catch (IOException ex) {
                Response abortResponse = requestContext.getAbortResponse();
                if (abortResponse == null) {
                    throw new WebApplicationException((Throwable)ex);
                }
                throw new WebApplicationException((Throwable)ex, abortResponse);
            }
        }
        return Stage.Continuation.of((Object)((Object)requestContext), (Stage)this.getDefaultNext());
    }

    static class Module
    extends AbstractModule {
        Module() {
        }

        protected void configure() {
            this.bind((Descriptor)BuilderHelper.link(Builder.class).build());
        }
    }

    private static class ResponseFilterStage
    extends AbstractChainableStage<ContainerResponse> {
        private final List<ContainerResponseFilter> filters;
        private final ServiceLocator locator;

        private ResponseFilterStage(List<ContainerResponseFilter> filters, ServiceLocator locator) {
            this.filters = filters;
            this.locator = locator;
        }

        public Stage.Continuation<ContainerResponse> apply(ContainerResponse responseContext) {
            try {
                RoutingContext rc = (RoutingContext)this.locator.getService(RoutingContext.class, new Annotation[0]);
                ArrayList<ContainerResponseFilter> sortedResponseFilters = new ArrayList<ContainerResponseFilter>(this.filters);
                if (rc != null) {
                    sortedResponseFilters.addAll(rc.getBoundResponseFilters());
                }
                Collections.sort(sortedResponseFilters, new PriorityComparator(PriorityComparator.Order.DESCENDING));
                for (ContainerResponseFilter filter : sortedResponseFilters) {
                    filter.filter((ContainerRequestContext)responseContext.getRequestContext(), (ContainerResponseContext)responseContext);
                }
            }
            catch (IOException ex) {
                throw new WebApplicationException((Throwable)ex);
            }
            return Stage.Continuation.of((Object)responseContext, (Stage)this.getDefaultNext());
        }
    }

    static class Builder {
        @Inject
        ServiceLocator locator;
        @Inject
        private Provider<ResponseProcessor.RespondingContext<ContainerResponse>> respondingContextFactory;

        Builder() {
        }

        public ContainerFilteringStage build(List<ContainerRequestFilter> requestFilters, List<ContainerResponseFilter> responseFilters) {
            return new ContainerFilteringStage(this.respondingContextFactory, this.locator, requestFilters, responseFilters);
        }
    }
}

