/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.io.Closeable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.server.CloseableService;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.inject.AbstractHttpContextValueFactory;
import org.glassfish.jersey.server.internal.inject.HttpContext;

public class CloseableServiceModule
extends AbstractModule {
    protected void configure() {
        this.bind(BuilderHelper.link(CloseableServiceFactory.class).to(CloseableService.class).in(Singleton.class).buildFactory());
    }

    private static class CloseableServiceFactory
    extends AbstractHttpContextValueFactory<CloseableService> {
        private CloseableServiceFactory() {
        }

        @Override
        @Singleton
        public CloseableService provide() {
            return (CloseableService)super.provide();
        }

        @Override
        protected CloseableService get(HttpContext context) {
            return new HttpContextCloseableService(context);
        }
    }

    private static class HttpContextCloseableService
    implements CloseableService {
        private static final Logger LOGGER = Logger.getLogger(HttpContextCloseableService.class.getName());
        private final HttpContext context;

        public HttpContextCloseableService(HttpContext context) {
            this.context = context;
        }

        @Override
        public void add(Closeable c) {
            Set<Closeable> closeableSet = this.getCloseables();
            if (closeableSet == null) {
                closeableSet = new HashSet<Closeable>();
                this.context.getRequestContext().setProperty(CloseableServiceFactory.class.getName(), closeableSet);
            }
            closeableSet.add(c);
        }

        @Override
        public void close() {
            Set<Closeable> closeableSet = this.getCloseables();
            if (closeableSet != null) {
                for (Closeable c : closeableSet) {
                    try {
                        c.close();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.CLOSEABLE_UNABLE_TO_CLOSE(c.getClass().getName()), ex);
                    }
                }
            }
        }

        private Set<Closeable> getCloseables() {
            ContainerRequest requestContext = this.context.getRequestContext();
            if (requestContext == null) {
                LOGGER.warning(LocalizationMessages.CLOSEABLE_INJECTED_REQUEST_CONTEXT_NULL(Thread.currentThread().getName()));
                return null;
            }
            return (Set)requestContext.getProperty(HttpContextCloseableService.class.getName());
        }
    }
}

