/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.FormParam;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.ExtractorException;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.inject.AbstractHttpContextValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.HttpContext;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
final class FormParamValueFactoryProvider
extends AbstractValueFactoryProvider<FormParam> {
    @Inject
    public FormParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator injector) {
        super(mpep, injector, Parameter.Source.FORM);
    }

    @Override
    public AbstractHttpContextValueFactory<?> createValueFactory(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.isEmpty()) {
            return null;
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new FormParamValueFactory(e);
    }

    private static final class FormParamValueFactory
    extends AbstractHttpContextValueFactory<Object> {
        private final MultivaluedParameterExtractor<?> extractor;

        FormParamValueFactory(MultivaluedParameterExtractor<?> extractor) {
            this.extractor = extractor;
        }

        @Override
        public Object get(HttpContext context) {
            Form form = this.getCachedForm(context);
            if (form == null) {
                form = this.getForm(context);
                this.cacheForm(context, form);
            }
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)form.asMap());
            }
            catch (ExtractorException e) {
                throw new ParamException.FormParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }

        private void cacheForm(HttpContext context, Form form) {
            context.getRequestContext().setProperty("jersey.config.server.representation.form", form);
        }

        private Form getForm(HttpContext context) {
            return this.getFormParameters(this.ensureValidRequest(context.getRequestContext()));
        }

        private Form getCachedForm(HttpContext context) {
            return (Form)context.getRequestContext().getProperty("jersey.config.server.representation.form");
        }

        private ContainerRequest ensureValidRequest(ContainerRequest requestContext) throws IllegalStateException {
            if (requestContext.getMethod().equals("GET")) {
                throw new IllegalStateException(LocalizationMessages.FORM_PARAM_METHOD_ERROR());
            }
            if (!MediaTypes.typeEqual((MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MediaType)requestContext.getMediaType())) {
                throw new IllegalStateException(LocalizationMessages.FORM_PARAM_CONTENT_TYPE_ERROR());
            }
            return requestContext;
        }

        private Form getFormParameters(ContainerRequest requestContext) {
            if (requestContext.getMediaType().equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
                requestContext.bufferEntity();
                Form f = requestContext.readEntity(Form.class);
                return f == null ? new Form() : f;
            }
            return new Form();
        }
    }

    @Singleton
    static final class InjectionResolver
    extends ParamInjectionResolver<FormParam> {
        public InjectionResolver() {
            super(FormParam.class, FormParamValueFactoryProvider.class);
        }
    }
}

