/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicBinder;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodDispatcherFactory;
import org.glassfish.jersey.server.model.ResourceMethodInvocationHandlerFactory;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;

public class ResourceMethodInvoker
implements Inflector<ContainerRequest, ContainerResponse>,
ResourceInfo {
    private final Provider<RoutingContext> routingContextFactory;
    private final Provider<InvocationContext> invocationContextFactory;
    private final ResourceMethod method;
    private final ResourceMethodDispatcher dispatcher;
    private final Method resourceMethod;
    private final Class<?> resourceClass;
    private final Collection<ContainerRequestFilter> requestFilters = new HashSet<ContainerRequestFilter>();
    private final Collection<ContainerResponseFilter> responseFilters = new HashSet<ContainerResponseFilter>();
    private final Collection<ReaderInterceptor> readerInterceptors = new HashSet<ReaderInterceptor>();
    private final Collection<WriterInterceptor> writerInterceptors = new HashSet<WriterInterceptor>();

    private ResourceMethodInvoker(Provider<RoutingContext> routingContextFactory, Provider<InvocationContext> invocationContextFactory, ResourceMethodDispatcher.Provider dispatcherProvider, ResourceMethodInvocationHandlerProvider invocationHandlerProvider, ResourceMethod method, MultivaluedMap<Class<? extends Annotation>, ContainerRequestFilter> nameBoundRequestFilters, MultivaluedMap<Class<? extends Annotation>, ContainerResponseFilter> nameBoundResponseFilters, Collection<DynamicBinder> dynamicBinders) {
        this.routingContextFactory = routingContextFactory;
        this.invocationContextFactory = invocationContextFactory;
        this.method = method;
        Invocable invocable = method.getInvocable();
        this.dispatcher = dispatcherProvider.create(invocable, invocationHandlerProvider.create(invocable));
        this.resourceMethod = invocable.getHandlingMethod();
        this.resourceClass = invocable.getHandler().getHandlerClass();
        for (DynamicBinder dynamicBinder : dynamicBinders) {
            Object boundProvider = dynamicBinder.getBoundProvider((ResourceInfo)this);
            if (boundProvider instanceof WriterInterceptor) {
                this.writerInterceptors.add((WriterInterceptor)boundProvider);
            }
            if (boundProvider instanceof ReaderInterceptor) {
                this.readerInterceptors.add((ReaderInterceptor)boundProvider);
            }
            if (boundProvider instanceof ContainerRequestFilter) {
                this.requestFilters.add((ContainerRequestFilter)boundProvider);
            }
            if (!(boundProvider instanceof ContainerResponseFilter)) continue;
            this.responseFilters.add((ContainerResponseFilter)boundProvider);
        }
        if (this.resourceMethod != null) {
            this.addNameBoundFilters(nameBoundRequestFilters, nameBoundResponseFilters, method);
        }
        if (this.resourceClass != null) {
            this.addNameBoundFilters(nameBoundRequestFilters, nameBoundResponseFilters, method);
        }
    }

    private void addNameBoundFilters(MultivaluedMap<Class<? extends Annotation>, ContainerRequestFilter> nameBoundRequestFilters, MultivaluedMap<Class<? extends Annotation>, ContainerResponseFilter> nameBoundResponseFilters, ResourceMethod method) {
        for (Class<? extends Annotation> nameBinding : method.getNameBindings()) {
            List resF;
            List reqF = (List)nameBoundRequestFilters.get(nameBinding);
            if (reqF != null) {
                this.requestFilters.addAll(reqF);
            }
            if ((resF = (List)nameBoundResponseFilters.get(nameBinding)) == null) continue;
            this.responseFilters.addAll(resF);
        }
    }

    public Method getResourceMethod() {
        return this.resourceMethod;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public ContainerResponse apply(ContainerRequest requestContext) {
        Type invocableType;
        Object resource = ((RoutingContext)this.routingContextFactory.get()).peekMatchedResource();
        InvocationContext invocationCtx = (InvocationContext)this.invocationContextFactory.get();
        if (this.method.isSuspendDeclared()) {
            invocationCtx.setSuspendTimeout(this.method.getSuspendTimeout(), this.method.getSuspendTimeoutUnit());
        }
        Response response = this.dispatcher.dispatch(resource, requestContext);
        if (this.method.isSuspendDeclared()) {
            invocationCtx.setResponse(resource);
            invocationCtx.trySuspend();
        }
        ContainerResponse responseContext = new ContainerResponse(requestContext, response);
        Invocable invocable = this.method.getInvocable();
        responseContext.setEntityAnnotations(invocable.getHandlingMethod().getDeclaredAnnotations());
        if (responseContext.hasEntity() && !(responseContext.getEntityType() instanceof ParameterizedType) && (invocableType = invocable.getResponseType()) != null && Void.TYPE != invocableType && Void.class != invocableType && invocableType != Response.class) {
            responseContext.setEntityType(invocableType);
        }
        return responseContext;
    }

    public Collection<ContainerRequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    public Collection<ContainerResponseFilter> getResponseFilters() {
        return this.responseFilters;
    }

    public Collection<WriterInterceptor> getWriterInterceptors() {
        return this.writerInterceptors;
    }

    public Collection<ReaderInterceptor> getReaderInterceptors() {
        return this.readerInterceptors;
    }

    public String toString() {
        return this.method.getInvocable().getHandlingMethod().toString();
    }

    public static class Builder {
        @Inject
        private Provider<RoutingContext> routingContextFactory;
        @Inject
        private Provider<InvocationContext> invocationContextFactory;
        @Inject
        private ResourceMethodDispatcherFactory dispatcherProviderFactory;
        @Inject
        private ResourceMethodInvocationHandlerFactory invocationHandlerProviderFactory;

        public ResourceMethodInvoker build(ResourceMethod method, MultivaluedMap<Class<? extends Annotation>, ContainerRequestFilter> nameBoundRequestFilters, MultivaluedMap<Class<? extends Annotation>, ContainerResponseFilter> nameBoundResponseFilters, Collection<DynamicBinder> dynamicBinders) {
            return new ResourceMethodInvoker(this.routingContextFactory, this.invocationContextFactory, this.dispatcherProviderFactory, this.invocationHandlerProviderFactory, method, nameBoundRequestFilters, nameBoundResponseFilters, dynamicBinders);
        }
    }
}

