/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.hk2.BinderFactory;
import org.glassfish.hk2.ComponentException;
import org.glassfish.hk2.DynamicBinderFactory;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.HK2;
import org.glassfish.hk2.Module;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.jersey.FeaturesAndProperties;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.ServiceProviders;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.InflectorNotFoundException;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ChunkedResponse;
import org.glassfish.jersey.server.CloseableService;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerFilteringStage;
import org.glassfish.jersey.server.ContainerMessageBodyWorkersInitializer;
import org.glassfish.jersey.server.ContainerResponseWriterCallback;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.JerseyContainerResponseContext;
import org.glassfish.jersey.server.ReferencesInitializer;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerModule;
import org.glassfish.jersey.server.TimingOutInvocationCallback;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.routing.RoutedInflectorExtractorStage;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingStage;
import org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import org.glassfish.jersey.server.model.BasicValidator;
import org.glassfish.jersey.server.model.ModelValidationException;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.model.ResourceModelValidator;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.spi.ContextResolvers;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.jvnet.hk2.annotations.Inject;

public final class ApplicationHandler {
    private static final Logger LOGGER = Logger.getLogger(ApplicationHandler.class.getName());
    private static final SecurityContext DEFAULT_SECURITY_CONTEXT = new SecurityContext(){

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    };
    @Inject
    private RequestScope requestScope;
    @Inject
    private Factory<CloseableService> closeableServiceFactory;
    private Services services;
    private RequestInvoker<JerseyContainerRequestContext, JerseyContainerResponseContext> invoker;
    private final ResourceConfig configuration;
    private References refs;

    public ApplicationHandler() {
        this.initServices();
        this.configuration = new ResourceConfig();
        this.initialize();
    }

    public ApplicationHandler(Class<? extends Application> jaxrsApplicationClass) {
        this.initServices();
        this.configuration = ResourceConfig.class.isAssignableFrom(jaxrsApplicationClass) ? (ResourceConfig)this.createApplication(jaxrsApplicationClass) : ResourceConfig.forApplicationClass(jaxrsApplicationClass);
        this.initialize();
    }

    public ApplicationHandler(Application application) {
        this.initServices();
        this.configuration = ResourceConfig.forApplication(application);
        this.initialize();
    }

    private void initServices() {
        this.services = HK2.get().create(null, new Module[]{new ServerModule(), new ApplicationModule()});
    }

    private void initialize() {
        this.registerAdditionalModules(this.configuration.getCustomModules());
        Class<? extends Application> applicationClass = this.configuration.getApplicationClass();
        if (applicationClass != null) {
            Application application = this.createApplication(applicationClass);
            if (application instanceof ResourceConfig) {
                this.registerAdditionalModules(((ResourceConfig)application).getCustomModules());
            }
            this.configuration.setApplication(application);
        }
        this.configuration.lock();
        LinkedList resourceModelIssues = Lists.newLinkedList();
        HashMap pathToResourceBuilderMap = Maps.newHashMap();
        LinkedList<Resource.Builder> resourcesBuilders = new LinkedList<Resource.Builder>();
        for (Class<?> c : this.configuration.getClasses()) {
            Path path = Resource.getPath(c);
            if (path == null) continue;
            try {
                String pathValue = path.value();
                Resource.Builder builder = Resource.builder(c, (List<ResourceModelIssue>)resourceModelIssues);
                Resource.Builder existing = (Resource.Builder)pathToResourceBuilderMap.get(pathValue);
                if (existing != null) {
                    existing.mergeWith(builder);
                    continue;
                }
                resourcesBuilders.add(builder);
                pathToResourceBuilderMap.put(pathValue, builder);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning(ex.getMessage());
            }
        }
        for (Resource programmaticResource : this.configuration.getResources()) {
            Resource.Builder builder = (Resource.Builder)pathToResourceBuilderMap.get(programmaticResource.getPath());
            if (builder != null) {
                builder.mergeWith(programmaticResource);
                continue;
            }
            resourcesBuilders.add(Resource.builder(programmaticResource));
        }
        Injector injector = (Injector)this.services.forContract(Injector.class).get();
        this.refs = (References)injector.inject(References.class);
        ServiceProviders providers = ((ServiceProviders.Builder)this.services.forContract(ServiceProviders.Builder.class).get()).setProviderClasses(Sets.filter(this.configuration.getClasses(), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                boolean acceptable = Resource.isAcceptable(input);
                if (!acceptable) {
                    LOGGER.warning(LocalizationMessages.NON_INSTANTIATABLE_CLASS(input));
                }
                return acceptable;
            }
        })).setProviderInstances(this.configuration.getSingletons()).build();
        this.refs.providers.set((Object)providers);
        MessageBodyFactory workers = new MessageBodyFactory(providers);
        this.refs.workers.set((Object)workers);
        this.refs.mappers.set((Object)new ExceptionMapperFactory(providers));
        this.refs.resolvers.set((Object)new ContextResolverFactory(providers));
        List<Resource> resources = this.buildAndValidate(resourcesBuilders, resourceModelIssues, (MessageBodyWorkers)workers);
        RuntimeModelBuilder runtimeModelBuilder = (RuntimeModelBuilder)this.services.byType(RuntimeModelBuilder.class).get();
        runtimeModelBuilder.setWorkers((MessageBodyWorkers)workers);
        for (Resource r : resources) {
            runtimeModelBuilder.process(r);
        }
        Router resourceRoutingRoot = runtimeModelBuilder.buildModel();
        ContainerFilteringStage preMatchRequestFilteringStage = ((ContainerFilteringStage.Builder)injector.inject(ContainerFilteringStage.Builder.class)).build(true);
        RoutingStage routingStage = ((RoutingStage.Builder)injector.inject(RoutingStage.Builder.class)).build(resourceRoutingRoot);
        ContainerFilteringStage resourceFilteringStage = ((ContainerFilteringStage.Builder)injector.inject(ContainerFilteringStage.Builder.class)).build(false);
        RoutedInflectorExtractorStage routedInflectorExtractorStage = (RoutedInflectorExtractorStage)injector.inject(RoutedInflectorExtractorStage.class);
        Stage rootStage = Stages.chain((Function)((Function)injector.inject(ReferencesInitializer.class))).to((Function)injector.inject(ContainerMessageBodyWorkersInitializer.class)).to((ChainableStage)preMatchRequestFilteringStage).to((ChainableStage)routingStage).to((ChainableStage)resourceFilteringStage).build((Stage)routedInflectorExtractorStage);
        this.invoker = ((ServerModule.RequestInvokerBuilder)injector.inject(ServerModule.RequestInvokerBuilder.class)).build((Stage<JerseyContainerRequestContext>)rootStage);
        injector.inject((Object)this);
    }

    private Application createApplication(Class<? extends Application> applicationClass) {
        if (applicationClass == ResourceConfig.class) {
            return new ResourceConfig();
        }
        if (applicationClass == Application.class) {
            return new Application();
        }
        return (Application)this.services.forContract(applicationClass).get();
    }

    public void registerAdditionalModules(Set<Module> modules) {
        DynamicBinderFactory dynamicBinderFactory = this.services.bindDynamically();
        for (Module module : modules) {
            module.configure((BinderFactory)dynamicBinderFactory);
        }
        dynamicBinderFactory.commit();
    }

    private List<Resource> buildAndValidate(List<Resource.Builder> resources, List<ResourceModelIssue> modelIssues, MessageBodyWorkers workers) {
        ArrayList<Resource> result = new ArrayList<Resource>(resources.size());
        BasicValidator validator = new BasicValidator(modelIssues, workers);
        for (Resource.Builder rb : resources) {
            Resource r = rb.build();
            result.add(r);
            validator.validate(r);
        }
        this.processIssues(validator);
        return result;
    }

    private void processIssues(ResourceModelValidator validator) {
        List<ResourceModelIssue> issueList = validator.getIssueList();
        if (!issueList.isEmpty()) {
            String allIssueMessages = this.allIssueLogMessages(validator.getIssueList());
            if (validator.fatalIssuesFound()) {
                LOGGER.severe(LocalizationMessages.ERRORS_AND_WARNINGS_DETECTED_WITH_RESOURCE_CLASSES(allIssueMessages));
            } else {
                LOGGER.warning(LocalizationMessages.WARNINGS_DETECTED_WITH_RESOURCE_CLASSES(allIssueMessages));
            }
        }
        if (validator.fatalIssuesFound()) {
            throw new ModelValidationException(issueList);
        }
    }

    private String allIssueLogMessages(List<ResourceModelIssue> issueList) {
        StringBuilder errors = new StringBuilder("\n");
        StringBuilder warnings = new StringBuilder();
        for (ResourceModelIssue issue : issueList) {
            if (issue.isFatal()) {
                errors.append(LocalizationMessages.ERROR_MSG(issue.getMessage())).append('\n');
                continue;
            }
            warnings.append(LocalizationMessages.WARNING_MSG(issue.getMessage())).append('\n');
        }
        return errors.append((CharSequence)warnings).toString();
    }

    public Future<JerseyContainerResponseContext> apply(JerseyContainerRequestContext requestContext) {
        return this.apply(requestContext, new OutputStream(){

            @Override
            public void write(int i) throws IOException {
            }
        });
    }

    public Future<JerseyContainerResponseContext> apply(final JerseyContainerRequestContext requestContext, final OutputStream outputStream) {
        requestContext.setSecurityContext(DEFAULT_SECURITY_CONTEXT);
        requestContext.setWriter(new ContainerResponseWriter(){

            @Override
            public OutputStream writeResponseStatusAndHeaders(long contentLength, JerseyContainerResponseContext responseContext) throws ContainerException {
                if (contentLength >= 0L) {
                    responseContext.getHeaders().putSingle((Object)"Content-Length", (Object)Long.toString(contentLength));
                }
                return outputStream;
            }

            @Override
            public void suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) throws IllegalStateException {
            }

            @Override
            public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            }

            @Override
            public void cancel() {
            }

            @Override
            public void commit() {
            }
        });
        TimingOutInvocationCallback callback = new TimingOutInvocationCallback(){

            @Override
            protected JerseyContainerResponseContext handleResponse(JerseyContainerResponseContext responseContext) {
                ApplicationHandler.this.writeResponse(requestContext, responseContext);
                if ("HEAD".equals(requestContext.getMethod())) {
                    ApplicationHandler.this.stripEntity(responseContext);
                }
                return responseContext;
            }

            @Override
            protected JerseyContainerResponseContext handleFailure(Throwable exception) {
                JerseyContainerResponseContext response = ApplicationHandler.handleFailure(exception, requestContext);
                ApplicationHandler.this.writeResponse(requestContext, response);
                return response;
            }

            @Override
            protected JerseyContainerResponseContext handleTimeout(InvocationContext context) {
                JerseyContainerResponseContext response = ApplicationHandler.prepareTimeoutResponse(context, requestContext);
                ApplicationHandler.this.writeResponse(requestContext, response);
                return response;
            }

            @Override
            protected void release() {
                ApplicationHandler.this.releaseRequestProcessing(requestContext);
            }
        };
        this.invoker.apply((Object)requestContext, (InvocationCallback)callback);
        return callback;
    }

    private JerseyContainerResponseContext stripEntity(JerseyContainerResponseContext responseContext) {
        if (responseContext.hasEntity()) {
            responseContext.setEntity(null);
        }
        return responseContext;
    }

    public void handle(JerseyContainerRequestContext requestContext) {
        this.checkContainerRequestContext(requestContext);
        ContainerResponseWriterCallback callback = new ContainerResponseWriterCallback(requestContext){

            @Override
            protected void writeResponse(JerseyContainerResponseContext response) {
                ApplicationHandler.this.writeResponse(this.requestContext, response);
            }

            @Override
            protected void writeResponse(Throwable exception) {
                ApplicationHandler.this.writeResponse(this.requestContext, ApplicationHandler.handleFailure(exception, this.requestContext));
            }

            @Override
            protected void writeTimeoutResponse(InvocationContext context) {
                ApplicationHandler.this.writeResponse(this.requestContext, ApplicationHandler.prepareTimeoutResponse(context, this.requestContext));
            }

            @Override
            protected void release() {
                ApplicationHandler.this.releaseRequestProcessing(this.requestContext);
            }
        };
        this.invoker.apply((Object)requestContext, (InvocationCallback)callback);
        callback.suspendWriterIfRunning();
    }

    private void releaseRequestProcessing(JerseyContainerRequestContext requestContext) {
        ((CloseableService)this.closeableServiceFactory.get()).close();
        Object property = requestContext.getProperty("jersey.config.server.chunked-mode");
        boolean isChunked = property instanceof Boolean ? (Boolean)property : false;
        if (!isChunked) {
            requestContext.getResponseWriter().commit();
        }
    }

    private void checkContainerRequestContext(JerseyContainerRequestContext requestContext) {
        if (requestContext.getSecurityContext() == null) {
            throw new IllegalArgumentException("SecurityContext from ContainerRequestContext must not be null.");
        }
        if (requestContext.getRequest() == null) {
            throw new IllegalArgumentException("Request from ContainerRequestContext must not be null.");
        }
        if (requestContext.getResponseWriter() == null) {
            throw new IllegalArgumentException("ResponseWriter from ContainerRequestContext must not be null.");
        }
    }

    private static JerseyContainerResponseContext prepareTimeoutResponse(InvocationContext context, JerseyContainerRequestContext requestContext) {
        Response response = context.getResponse();
        if (response == null) {
            response = Response.serverError().entity((Object)"Request processing has timed out.").type("text/plain").build();
        }
        return new JerseyContainerResponseContext(requestContext, response);
    }

    private static JerseyContainerResponseContext handleFailure(Throwable failure, JerseyContainerRequestContext requestContext) {
        Response.Status statusCode = Response.Status.INTERNAL_SERVER_ERROR;
        String message = failure.getMessage();
        if (failure instanceof ProcessingException) {
            if (failure instanceof HeaderValueException) {
                statusCode = Response.Status.BAD_REQUEST;
            } else if (failure instanceof InflectorNotFoundException) {
                statusCode = Response.Status.NOT_FOUND;
                message = "Requested resource not found.";
            }
        }
        if (statusCode == Response.Status.INTERNAL_SERVER_ERROR) {
            LOGGER.log(Level.SEVERE, message, failure);
        } else {
            LOGGER.log(Level.FINE, message, failure);
        }
        return new JerseyContainerResponseContext(requestContext, Response.status((Response.StatusType)statusCode).entity((Object)message).type("text/plain").build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(JerseyContainerRequestContext requestContext, final JerseyContainerResponseContext responseContext) {
        final ContainerResponseWriter writer = requestContext.getResponseWriter();
        final MessageBodySizeCallback messageBodySizeCallback = new MessageBodySizeCallback();
        if (!responseContext.hasEntity()) {
            writer.writeResponseStatusAndHeaders(0L, responseContext);
            return;
        }
        Object entity = responseContext.getEntity();
        try {
            responseContext.setStreamProvider(new OutboundMessageContext.StreamProvider(){
                private OutputStream output;

                public void commit() throws IOException {
                    this.output = writer.writeResponseStatusAndHeaders(messageBodySizeCallback.getSize(), responseContext);
                }

                public OutputStream getOutputStream() throws IOException {
                    return this.output;
                }
            });
            requestContext.getWorkers().writeTo(entity, entity.getClass(), responseContext.getEntityType(), responseContext.getEntityAnnotations(), responseContext.getMediaType(), responseContext.getHeaders(), requestContext.getPropertiesDelegate(), responseContext.getEntityStream(), (MessageBodyWorkers.MessageBodySizeCallback)messageBodySizeCallback, true, !requestContext.getMethod().equals("HEAD"));
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_WRITING_RESPONSE_ENTITY(), ex);
        }
        finally {
            responseContext.commitStream();
            if (ChunkedResponse.class.isAssignableFrom(entity.getClass())) {
                try {
                    ((ChunkedResponse)entity).setContext(requestContext, responseContext);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_WRITING_RESPONSE_ENTITY_CHUNK(), ex);
                }
                requestContext.setProperty("jersey.config.server.chunked-mode", Boolean.TRUE);
                writer.suspend(0L, TimeUnit.SECONDS, null);
            }
        }
    }

    public Services getServices() {
        return this.services;
    }

    public ServiceProviders getServiceProviders() {
        return (ServiceProviders)this.refs.providers.get();
    }

    public ResourceConfig getConfiguration() {
        return this.configuration;
    }

    private class MessageBodySizeCallback
    implements MessageBodyWorkers.MessageBodySizeCallback {
        private long size = -1L;

        private MessageBodySizeCallback() {
        }

        public void onRequestEntitySize(long size) throws IOException {
            this.size = size;
        }

        public long getSize() {
            return this.size;
        }
    }

    private class ApplicationModule
    extends AbstractModule {
        private ApplicationModule() {
        }

        protected void configure() {
            ResourceConfigProvider rcp = new ResourceConfigProvider();
            this.bind(ResourceConfig.class, new Class[0]).toFactory((Factory)rcp).in(Singleton.class);
            this.bind(FeaturesAndProperties.class, new Class[0]).toFactory((Factory)rcp).in(Singleton.class);
            this.bind(Application.class, new Class[0]).toFactory((Factory)new JaxrsApplicationProvider()).in(Singleton.class);
            this.bind(ApplicationHandler.class, new Class[0]).toInstance((Object)ApplicationHandler.this);
        }

        private class ResourceConfigProvider
        implements Factory<ResourceConfig> {
            private ResourceConfigProvider() {
            }

            public ResourceConfig get() throws ComponentException {
                return ApplicationHandler.this.configuration;
            }
        }

        private class JaxrsApplicationProvider
        implements Factory<Application> {
            private JaxrsApplicationProvider() {
            }

            public Application get() throws ComponentException {
                return ApplicationHandler.this.configuration.getApplication();
            }
        }
    }

    private static class References {
        @Inject
        private Ref<ServiceProviders> providers;
        @Inject
        private Ref<ExceptionMappers> mappers;
        @Inject
        private Ref<MessageBodyWorkers> workers;
        @Inject
        private Ref<ContextResolvers> resolvers;

        private References() {
        }
    }
}

