/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.JerseyContainerResponseContext;

public class ChunkedResponse<T>
implements Closeable {
    static final String CHUNKED_MODE = "jersey.config.server.chunked-mode";
    private final BlockingDeque<T> queue = new LinkedBlockingDeque<T>();
    private final GenericType<T> chunkType;
    private boolean closed = false;
    private JerseyContainerRequestContext requestContext;
    private JerseyContainerResponseContext responseContext;

    public ChunkedResponse(Type chunkType) {
        this.chunkType = new GenericType(chunkType);
    }

    public ChunkedResponse(GenericType<T> genericType) {
        this.chunkType = genericType;
    }

    public void write(T chunk) throws IOException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (chunk != null) {
            this.queue.add(chunk);
        }
        this.flushQueue();
    }

    private synchronized void flushQueue() throws IOException {
        T t;
        if (this.requestContext == null) {
            return;
        }
        while ((t = this.queue.poll()) != null) {
            this.requestContext.getWorkers().writeTo(t, t.getClass(), this.chunkType.getType(), this.responseContext.getEntityAnnotations(), this.responseContext.getMediaType(), this.responseContext.getHeaders(), this.requestContext.getPropertiesDelegate(), this.responseContext.getEntityStream(), null, true);
        }
        if (this.closed) {
            this.responseContext.getEntityStream().flush();
            this.responseContext.getEntityStream().close();
            this.requestContext.getResponseWriter().commit();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.flushQueue();
    }

    public boolean isClosed() {
        return this.closed;
    }

    void setContext(JerseyContainerRequestContext requestContext, JerseyContainerResponseContext responseContext) throws IOException {
        this.requestContext = requestContext;
        this.responseContext = responseContext;
        this.flushQueue();
    }
}

