/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.NameBinding;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PostMatching;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.ServiceProviders;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AbstractChainableStage;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.PriorityComparator;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.JerseyContainerResponseContext;
import org.jvnet.hk2.annotations.Inject;

class ContainerFilteringStage
extends AbstractChainableStage<JerseyContainerRequestContext> {
    private static final Predicate<ContainerRequestFilter> PRE_MATCH_FILTER_PREDICATE = new Predicate<ContainerRequestFilter>(){

        public boolean apply(ContainerRequestFilter filter) {
            for (Annotation annotation : filter.getClass().getAnnotations()) {
                if (annotation instanceof PostMatching) {
                    return false;
                }
                for (Annotation metaAnnotation : annotation.getClass().getAnnotations()) {
                    if (!(metaAnnotation instanceof NameBinding)) continue;
                    return false;
                }
            }
            return true;
        }
    };
    private static final Predicate<ContainerRequestFilter> POST_MATCH_FILTER_PREDICATE = new Predicate<ContainerRequestFilter>(){

        public boolean apply(ContainerRequestFilter filter) {
            for (Annotation annotation : filter.getClass().getAnnotations()) {
                if (annotation instanceof PostMatching) {
                    return true;
                }
                for (Annotation metaAnnotation : annotation.getClass().getAnnotations()) {
                    if (!(metaAnnotation instanceof NameBinding)) continue;
                    return true;
                }
            }
            return false;
        }
    };
    private final Factory<ServiceProviders> servicesProvidersFactory;
    private final Factory<ResponseProcessor.RespondingContext<JerseyContainerResponseContext>> respondingContextFactory;
    private final boolean preMatch;

    private ContainerFilteringStage(Factory<ServiceProviders> servicesProvidersFactory, Factory<ResponseProcessor.RespondingContext<JerseyContainerResponseContext>> respondingContextFactory, boolean preMatch) {
        this.servicesProvidersFactory = servicesProvidersFactory;
        this.respondingContextFactory = respondingContextFactory;
        this.preMatch = preMatch;
    }

    public Stage.Continuation<JerseyContainerRequestContext> apply(JerseyContainerRequestContext requestContext) {
        ServiceProviders serviceProviders = (ServiceProviders)this.servicesProvidersFactory.get();
        List responseFilters = serviceProviders.getAll(ContainerResponseFilter.class, (Comparator)new PriorityComparator(PriorityComparator.Order.DESCENDING));
        if (!responseFilters.isEmpty()) {
            ((ResponseProcessor.RespondingContext)this.respondingContextFactory.get()).push((ChainableStage)new ResponseFilterStage(responseFilters));
        }
        Iterable requestFilters = serviceProviders.getAll(ContainerRequestFilter.class, (Comparator)new PriorityComparator(PriorityComparator.Order.ASCENDING));
        requestFilters = this.preMatch ? Iterables.filter((Iterable)requestFilters, PRE_MATCH_FILTER_PREDICATE) : Iterables.filter((Iterable)requestFilters, POST_MATCH_FILTER_PREDICATE);
        for (ContainerRequestFilter filter : requestFilters) {
            try {
                filter.filter((ContainerRequestContext)requestContext);
                final Response abortResponse = requestContext.getAbortResponse();
                if (abortResponse == null) continue;
                return Stage.Continuation.of((Object)((Object)requestContext), (Stage)Stages.asStage((Inflector)new Inflector<JerseyContainerRequestContext, JerseyContainerResponseContext>(){

                    public JerseyContainerResponseContext apply(JerseyContainerRequestContext requestContext) {
                        return new JerseyContainerResponseContext(requestContext, abortResponse);
                    }
                }));
            }
            catch (IOException ex) {
                Response abortResponse = requestContext.getAbortResponse();
                if (abortResponse == null) {
                    throw new WebApplicationException((Throwable)ex);
                }
                throw new WebApplicationException((Throwable)ex, abortResponse);
            }
        }
        return Stage.Continuation.of((Object)((Object)requestContext), (Stage)this.getDefaultNext());
    }

    static class Module
    extends AbstractModule {
        Module() {
        }

        protected void configure() {
            this.bind().to(Builder.class);
        }
    }

    private static class ResponseFilterStage
    extends AbstractChainableStage<JerseyContainerResponseContext> {
        private final List<ContainerResponseFilter> filters;

        private ResponseFilterStage(List<ContainerResponseFilter> filters) {
            this.filters = filters;
        }

        public Stage.Continuation<JerseyContainerResponseContext> apply(JerseyContainerResponseContext responseContext) {
            try {
                for (ContainerResponseFilter filter : this.filters) {
                    filter.filter((ContainerRequestContext)responseContext.getRequestContext(), (ContainerResponseContext)responseContext);
                }
            }
            catch (IOException ex) {
                throw new WebApplicationException((Throwable)ex);
            }
            return Stage.Continuation.of((Object)((Object)responseContext), (Stage)this.getDefaultNext());
        }
    }

    static class Builder {
        @Inject
        private Factory<ServiceProviders> servicesProvidersFactory;
        @Inject
        private Factory<ResponseProcessor.RespondingContext<JerseyContainerResponseContext>> respondingContextFactory;

        Builder() {
        }

        public ContainerFilteringStage build(boolean preMatch) {
            return new ContainerFilteringStage(this.servicesProvidersFactory, this.respondingContextFactory, preMatch);
        }
    }
}

