/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.util.concurrent.TimeUnit;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.JerseyContainerResponseContext;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

abstract class ContainerResponseWriterCallback
implements InvocationCallback<JerseyContainerResponseContext> {
    private boolean suspended = false;
    private boolean autosuspend = false;
    private boolean done;
    private boolean timeoutCancelled = false;
    private final Object stateUpdateLock = new Object();
    private InvocationContext invocationContext;
    protected final JerseyContainerRequestContext requestContext;

    public ContainerResponseWriterCallback(JerseyContainerRequestContext requestContext) {
        this.requestContext = requestContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void result(JerseyContainerResponseContext response) {
        Object object = this.stateUpdateLock;
        synchronized (object) {
            if (this.done) {
                return;
            }
            this.timeoutCancelled = true;
            this.done = true;
        }
        try {
            this.writeResponse(response);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failure(Throwable exception) {
        Object object = this.stateUpdateLock;
        synchronized (object) {
            if (this.done) {
                return;
            }
            this.timeoutCancelled = true;
            this.done = true;
        }
        try {
            this.writeResponse(exception);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelled() {
        Object object = this.stateUpdateLock;
        synchronized (object) {
            if (this.done) {
                return;
            }
            this.timeoutCancelled = true;
            this.done = true;
        }
        try {
            this.requestContext.getResponseWriter().cancel();
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspended(long time, TimeUnit unit, InvocationContext context) {
        Object object = this.stateUpdateLock;
        synchronized (object) {
            this.invocationContext = context;
            if (this.autosuspend) {
                this.suspendTimeoutChanged(time, unit);
            } else {
                this.suspendWriter(time, unit);
            }
        }
    }

    private void suspendWriter(long time, TimeUnit unit) {
        this.requestContext.getResponseWriter().suspend(time, unit, new ContainerResponseWriter.TimeoutHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTimeout(ContainerResponseWriter responseWriter) {
                Object object = ContainerResponseWriterCallback.this.stateUpdateLock;
                synchronized (object) {
                    if (ContainerResponseWriterCallback.this.timeoutCancelled || ContainerResponseWriterCallback.this.done) {
                        return;
                    }
                    ContainerResponseWriterCallback.this.done = true;
                }
                ContainerResponseWriterCallback.this.writeTimeoutResponse(ContainerResponseWriterCallback.this.invocationContext);
            }
        });
        this.suspended = true;
    }

    public void suspendTimeoutChanged(long time, TimeUnit unit) {
        this.requestContext.getResponseWriter().setSuspendTimeout(time, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumed() {
        Object object = this.stateUpdateLock;
        synchronized (object) {
            this.timeoutCancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspendWriterIfRunning() {
        Object object = this.stateUpdateLock;
        synchronized (object) {
            if (this.done || this.suspended) {
                return;
            }
            this.autosuspend = true;
            this.suspendWriter(0L, TimeUnit.MILLISECONDS);
        }
    }

    protected abstract void writeResponse(JerseyContainerResponseContext var1);

    protected abstract void writeResponse(Throwable var1);

    protected abstract void writeTimeoutResponse(InvocationContext var1);

    protected abstract void release();
}

