/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.util.concurrent.AbstractFuture;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.server.JerseyContainerResponseContext;

abstract class TimingOutInvocationCallback
extends AbstractFuture<JerseyContainerResponseContext>
implements InvocationCallback<JerseyContainerResponseContext> {
    private static final Logger logger = Logger.getLogger(TimingOutInvocationCallback.class.getName());
    private static final Timer TIMER = new Timer("Jersey application request timer");
    private final Object suspendLock = new Object();
    private final AtomicBoolean done = new AtomicBoolean(false);
    private InvocationContext invocationCtx = null;
    private TimerTask timeoutTask = null;

    protected TimingOutInvocationCallback() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void result(JerseyContainerResponseContext response) {
        if (this.done.compareAndSet(false, true)) {
            try {
                this.set((Object)this.handleResponse(response));
            }
            catch (Throwable t) {
                this.setException(t);
            }
            finally {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failure(Throwable failure) {
        if (this.done.compareAndSet(false, true)) {
            try {
                this.set((Object)this.handleFailure(failure));
            }
            catch (Throwable t) {
                this.setException(t);
            }
            finally {
                this.release();
            }
        }
    }

    protected abstract JerseyContainerResponseContext handleFailure(Throwable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelled() {
        if (this.done.compareAndSet(false, true)) {
            try {
                this.cancel(true);
            }
            finally {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspended(long time, TimeUnit unit, InvocationContext context) {
        TimerTask task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (TimingOutInvocationCallback.this.done.compareAndSet(false, true)) {
                    try {
                        TimingOutInvocationCallback.this.set((Object)TimingOutInvocationCallback.this.handleTimeout(TimingOutInvocationCallback.this.invocationCtx));
                    }
                    catch (Throwable t) {
                        TimingOutInvocationCallback.this.setException(t);
                    }
                    finally {
                        TimingOutInvocationCallback.this.release();
                    }
                }
            }
        };
        Object object = this.suspendLock;
        synchronized (object) {
            if (this.invocationCtx != null) {
                throw new IllegalStateException("Already suspended");
            }
            this.invocationCtx = context;
            if (time <= 0L) {
                return;
            }
            this.timeoutTask = task;
        }
        try {
            TIMER.schedule(task, unit.toMillis(time));
        }
        catch (IllegalStateException ex) {
            logger.log(Level.WARNING, "Error while scheduling a timeout task.", ex);
        }
    }

    protected abstract JerseyContainerResponseContext handleTimeout(InvocationContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendTimeoutChanged(long time, TimeUnit unit) {
        if (!this.done.get()) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (TimingOutInvocationCallback.this.done.compareAndSet(false, true)) {
                        try {
                            TimingOutInvocationCallback.this.set((Object)TimingOutInvocationCallback.this.handleTimeout(TimingOutInvocationCallback.this.invocationCtx));
                        }
                        catch (Throwable t) {
                            TimingOutInvocationCallback.this.setException(t);
                        }
                    }
                }
            };
            Object object = this.suspendLock;
            synchronized (object) {
                if (this.timeoutTask != null) {
                    this.timeoutTask.cancel();
                }
                this.timeoutTask = task;
            }
            try {
                TIMER.schedule(task, unit.toMillis(time));
            }
            catch (IllegalStateException ex) {
                logger.log(Level.WARNING, "Error while scheduling a timeout task.", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumed() {
        Object object = this.suspendLock;
        synchronized (object) {
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel();
            }
        }
    }

    protected abstract JerseyContainerResponseContext handleResponse(JerseyContainerResponseContext var1);

    protected abstract void release();
}

