/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.ExtractorException;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractHttpContextValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.HttpContext;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.jvnet.hk2.annotations.Inject;

final class HeaderParamValueFactoryProvider
extends AbstractValueFactoryProvider<HeaderParam> {
    public HeaderParamValueFactoryProvider(@Inject MultivaluedParameterExtractorProvider mpep, @Inject Injector injector) {
        super(mpep, injector, Parameter.Source.HEADER);
    }

    @Override
    public AbstractHttpContextValueFactory<?> createValueFactory(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new HeaderParamValueFactory(e);
    }

    private static final class HeaderParamValueFactory
    extends AbstractHttpContextValueFactory<Object> {
        private MultivaluedParameterExtractor<?> extractor;

        HeaderParamValueFactory(MultivaluedParameterExtractor<?> extractor) {
            this.extractor = extractor;
        }

        @Override
        public Object get(HttpContext context) {
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)context.getRequestContext().getHeaders());
            }
            catch (ExtractorException e) {
                throw new ParamException.HeaderParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }

    static final class InjectionResolver
    extends ParamInjectionResolver<HeaderParam> {
        public InjectionResolver() {
            super(HeaderParam.class, HeaderParamValueFactoryProvider.class);
        }
    }
}

