/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.sun.hk2.component.InjectionResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Set;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Services;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.tiger_types.Types;

public abstract class ParamInjectionResolver<A extends Annotation>
extends InjectionResolver<A> {
    @Inject
    private Services services;
    final Predicate<ValueFactoryProvider> concreteValueFactoryClassFilter;

    public ParamInjectionResolver(Class<A> injectionAnnotationClass, final Class<? extends AbstractValueFactoryProvider<A>> valueFactoryProviderClass) {
        super(injectionAnnotationClass);
        this.concreteValueFactoryClassFilter = new Predicate<ValueFactoryProvider>(){

            public boolean apply(ValueFactoryProvider input) {
                return valueFactoryProviderClass.isInstance(input);
            }
        };
    }

    public boolean isOptional(AnnotatedElement annotated, A annotation) {
        return true;
    }

    public <V> V getValue(Object component, Inhabitant<?> onBehalfOf, AnnotatedElement annotated, Type genericType, Class<V> type) throws ComponentException {
        Class targetType;
        Type targetGenericType;
        boolean isHk2Factory = Types.isSubClassOf(type, Factory.class);
        if (isHk2Factory) {
            targetGenericType = Types.getTypeArgument((Type)genericType, (int)0);
            targetType = Types.erasure((Type)targetGenericType);
        } else {
            targetGenericType = genericType;
            targetType = type;
        }
        Set providers = Sets.filter((Set)Providers.getProviders((Services)this.services, ValueFactoryProvider.class), this.concreteValueFactoryClassFilter);
        ValueFactoryProvider valueFactoryProvider = (ValueFactoryProvider)providers.iterator().next();
        Parameter parameter = Parameter.create(component.getClass(), component.getClass(), false, targetType, targetGenericType, annotated.getDeclaredAnnotations());
        Factory<?> valueFactory = valueFactoryProvider.getValueFactory(parameter);
        if (valueFactory != null) {
            if (isHk2Factory) {
                return (V)valueFactory;
            }
            return (V)valueFactory.get();
        }
        return null;
    }
}

