/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.collect.Lists;
import java.util.List;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Provider;
import org.glassfish.hk2.Services;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.internal.routing.Route;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RouterModule;

abstract class AbstractRouteToPathBuilder<T>
implements RouterModule.RouteToPathBuilder<T> {
    private final Services services;
    private final List<Route<T>> acceptedRoutes = Lists.newLinkedList();
    private List<Factory<Router>> currentRouters;

    protected AbstractRouteToPathBuilder(Services services, T pattern) {
        this.services = services;
        this._route(pattern);
    }

    protected final RouterModule.RouteToBuilder<T> _route(T pattern) {
        this.currentRouters = Lists.newLinkedList();
        this.acceptedRoutes.add(Route.of(pattern, this.currentRouters));
        return this;
    }

    protected final RouterModule.RouteToPathBuilder<T> _to(Factory<? extends Router> pa) {
        this.currentRouters.add(pa);
        return this;
    }

    protected List<Route<T>> acceptedRoutes() {
        return this.acceptedRoutes;
    }

    @Override
    public final RouterModule.RouteToPathBuilder<T> to(Router.Builder ab) {
        return this.to(ab.build());
    }

    @Override
    public final RouterModule.RouteToPathBuilder<T> to(Router a) {
        return this.to((Factory<Router>)Providers.factoryOf((Object)a));
    }

    @Override
    public final RouterModule.RouteToPathBuilder<T> to(Class<? extends Router> ca) {
        return this.to((Factory<Router>)Providers.asFactory((Provider)this.services.forContract(ca).getProvider()));
    }

    @Override
    public final RouterModule.RouteToPathBuilder<T> to(Factory<? extends Router> pa) {
        return this._to(pa);
    }

    @Override
    public abstract RouterModule.RouteToBuilder<T> route(String var1);

    @Override
    public RouterModule.RouteToBuilder<T> route(T pattern) {
        return this._route(pattern);
    }

    @Override
    public Router.Builder child(Router child) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public abstract Router build();
}

