/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.JerseyContainerResponseContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.routing.CombinedClientServerMediaType;
import org.glassfish.jersey.server.internal.routing.MethodAcceptorPair;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.Routers;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.jvnet.hk2.annotations.Inject;

final class MethodSelectingRouter
implements Router {
    private static final Logger LOGGER = Logger.getLogger(MethodSelectingRouter.class.getName());
    private final Factory<ResponseProcessor.RespondingContext<JerseyContainerResponseContext>> respondingContextFactory;
    private final MessageBodyWorkers workers;
    private final Map<String, List<ConsumesProducesAcceptor>> consumesProducesAcceptors;
    private final Router router;

    private MethodSelectingRouter(Factory<ResponseProcessor.RespondingContext<JerseyContainerResponseContext>> respondingContextFactory, MessageBodyWorkers msgWorkers, List<MethodAcceptorPair> methodAcceptorPairs) {
        this.respondingContextFactory = respondingContextFactory;
        this.workers = msgWorkers;
        this.consumesProducesAcceptors = new HashMap<String, List<ConsumesProducesAcceptor>>();
        for (MethodAcceptorPair methodAcceptorPair : methodAcceptorPairs) {
            String httpMethod = methodAcceptorPair.model.getHttpMethod();
            List<ConsumesProducesAcceptor> httpMethodBoundAcceptors = this.consumesProducesAcceptors.get(httpMethod);
            if (httpMethodBoundAcceptors == null) {
                httpMethodBoundAcceptors = new LinkedList<ConsumesProducesAcceptor>();
                this.consumesProducesAcceptors.put(httpMethod, httpMethodBoundAcceptors);
            }
            this.addAllConsumesProducesCombinations(httpMethodBoundAcceptors, methodAcceptorPair);
        }
        this.router = !this.consumesProducesAcceptors.containsKey("HEAD") ? this.createHeadEnrichedRouter() : this.createInternalRouter();
        if (!this.consumesProducesAcceptors.containsKey("OPTIONS")) {
            this.addOptionsSupport();
        }
    }

    private Router createInternalRouter() {
        return new Router(){

            @Override
            public Router.Continuation apply(JerseyContainerRequestContext requestContext) {
                return Router.Continuation.of(requestContext, MethodSelectingRouter.this.getMethodRouter(requestContext));
            }
        };
    }

    @Override
    public Router.Continuation apply(JerseyContainerRequestContext requestContext) {
        return this.router.apply(requestContext);
    }

    private void addAllConsumesProducesCombinations(List<ConsumesProducesAcceptor> list, MethodAcceptorPair methodAcceptorPair) {
        LinkedList<MediaType> effectiveInputTypes = new LinkedList<MediaType>();
        ResourceMethod resourceMethod = methodAcceptorPair.model;
        boolean consumesFromWorkers = this.fillMediaTypes(effectiveInputTypes, resourceMethod, resourceMethod.getConsumedTypes(), true);
        LinkedList<MediaType> effectiveOutputTypes = new LinkedList<MediaType>();
        boolean producesFromWorkers = this.fillMediaTypes(effectiveOutputTypes, resourceMethod, resourceMethod.getProducedTypes(), false);
        for (MediaType consumes : effectiveInputTypes) {
            for (MediaType produces : effectiveOutputTypes) {
                list.add(new ConsumesProducesAcceptor(new CombinedClientServerMediaType.EffectiveMediaType(consumes, consumesFromWorkers), new CombinedClientServerMediaType.EffectiveMediaType(produces, producesFromWorkers), methodAcceptorPair));
            }
        }
    }

    private boolean fillMediaTypes(List<MediaType> effectiveTypes, ResourceMethod resourceMethod, List<MediaType> methodTypes, boolean inputTypes) {
        boolean consumesFromWorkers = false;
        effectiveTypes.addAll(methodTypes);
        if (effectiveTypes.isEmpty() && this.workers != null) {
            Invocable invocableMethod = resourceMethod.getInvocable();
            if (inputTypes) {
                this.fillInputTypesFromWorkers(effectiveTypes, invocableMethod);
            } else {
                this.fillOutputParameters(effectiveTypes, invocableMethod);
            }
            boolean bl = consumesFromWorkers = !effectiveTypes.isEmpty();
        }
        if (effectiveTypes.isEmpty()) {
            effectiveTypes.add(MediaType.valueOf((String)"*/*"));
        }
        return consumesFromWorkers;
    }

    private void fillOutputParameters(List<MediaType> effectiveOutputTypes, Invocable invocableMethod) {
        List messageBodyWriterMediaTypes = this.workers.getMessageBodyWriterMediaTypes(invocableMethod.getRawResponseType(), invocableMethod.getResponseType(), invocableMethod.getHandlingMethod().getDeclaredAnnotations());
        effectiveOutputTypes.addAll(messageBodyWriterMediaTypes);
    }

    private void fillInputTypesFromWorkers(List<MediaType> effectiveInputTypes, Invocable invocableMethod) {
        for (Parameter p : invocableMethod.getParameters()) {
            if (p.getSource() != Parameter.Source.ENTITY) continue;
            List messageBodyReaderMediaTypes = this.workers.getMessageBodyReaderMediaTypes(p.getRawType(), p.getType(), p.getDeclaredAnnotations());
            effectiveInputTypes.addAll(messageBodyReaderMediaTypes);
        }
    }

    private Router getMethodRouter(JerseyContainerRequestContext requestContext) {
        List<ConsumesProducesAcceptor> acceptors = this.consumesProducesAcceptors.get(requestContext.getMethod());
        if (acceptors == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).allow(this.consumesProducesAcceptors.keySet()).build());
        }
        LinkedList<ConsumesProducesAcceptor> satisfyingAcceptors = new LinkedList<ConsumesProducesAcceptor>();
        for (ConsumesProducesAcceptor cpi : acceptors) {
            if (!cpi.isConsumable(requestContext)) continue;
            satisfyingAcceptors.add(cpi);
        }
        if (satisfyingAcceptors.isEmpty()) {
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
        List<MediaType> acceptableMediaTypes = requestContext.getAcceptableMediaTypes();
        MethodSelector methodSelector = new MethodSelector(null);
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            for (ConsumesProducesAcceptor satisfiable : satisfyingAcceptors) {
                if (!satisfiable.produces.getMediaType().isCompatible(acceptableMediaType)) continue;
                MediaType requestContentType = requestContext.getMediaType();
                MediaType effectiveContentType = requestContentType == null ? MediaType.WILDCARD_TYPE : requestContentType;
                RequestSpecificConsumesProducesAcceptor candidate = new RequestSpecificConsumesProducesAcceptor(CombinedClientServerMediaType.create(effectiveContentType, satisfiable.getConsumes()), CombinedClientServerMediaType.create(acceptableMediaType, satisfiable.getProduces()), satisfiable.methodAcceptorPair);
                methodSelector.consider(candidate);
            }
        }
        if (methodSelector.selected != null) {
            RequestSpecificConsumesProducesAcceptor selected = methodSelector.selected;
            if (methodSelector.sameFitnessAcceptors != null) {
                this.reportMethodSelectionAmbiguity(acceptableMediaTypes, selected, methodSelector.sameFitnessAcceptors);
            }
            final MediaType effectiveResponseType = selected.produces.getCombinedMediaType();
            ((ResponseProcessor.RespondingContext)this.respondingContextFactory.get()).push((Function)new Function<JerseyContainerResponseContext, JerseyContainerResponseContext>(){

                public JerseyContainerResponseContext apply(JerseyContainerResponseContext responseContext) {
                    boolean isHeadRequest = "HEAD".equals(responseContext.getRequestContext().getMethod());
                    if ((responseContext.hasEntity() || isHeadRequest) && !MethodSelectingRouter.this.isWildcard(effectiveResponseType) && responseContext.getMediaType() == null) {
                        responseContext.setMediaType(effectiveResponseType);
                    }
                    return responseContext;
                }
            });
            return selected.methodAcceptorPair.router;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build());
    }

    private boolean isWildcard(MediaType effectiveResponseType) {
        return effectiveResponseType.isWildcardType() || effectiveResponseType.isWildcardSubtype();
    }

    private void reportMethodSelectionAmbiguity(List<MediaType> acceptableTypes, RequestSpecificConsumesProducesAcceptor selected, List<RequestSpecificConsumesProducesAcceptor> sameFitnessAcceptors) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            StringBuilder msgBuilder = new StringBuilder(LocalizationMessages.AMBIGUOUS_RESOURCE_METHOD(acceptableTypes)).append('\n');
            msgBuilder.append('\t').append(selected.methodAcceptorPair.model).append('\n');
            HashSet reportedMethods = Sets.newHashSet();
            reportedMethods.add(selected.methodAcceptorPair.model);
            for (RequestSpecificConsumesProducesAcceptor i : sameFitnessAcceptors) {
                if (!reportedMethods.contains(i.methodAcceptorPair.model)) {
                    msgBuilder.append('\t').append(i.methodAcceptorPair.model).append('\n');
                }
                reportedMethods.add(i.methodAcceptorPair.model);
            }
            LOGGER.log(Level.WARNING, msgBuilder.toString());
        }
    }

    private void addOptionsSupport() {
        HashSet<String> allowedMethods = new HashSet<String>(this.consumesProducesAcceptors.keySet());
        allowedMethods.add("HEAD");
        allowedMethods.add("OPTIONS");
        LinkedList<ConsumesProducesAcceptor> optionsAcceptors = new LinkedList<ConsumesProducesAcceptor>();
        optionsAcceptors.add(this.createPlainTextOptionsInflector(allowedMethods));
        optionsAcceptors.add(this.createGenericOptionsInflector(allowedMethods));
        this.consumesProducesAcceptors.put("OPTIONS", optionsAcceptors);
    }

    private Router createHeadEnrichedRouter() {
        return new Router(){

            @Override
            public Router.Continuation apply(JerseyContainerRequestContext requestContext) {
                if ("HEAD".equals(requestContext.getMethod())) {
                    requestContext.setMethod("GET");
                    ((ResponseProcessor.RespondingContext)MethodSelectingRouter.this.respondingContextFactory.get()).push((Function)new Function<JerseyContainerResponseContext, JerseyContainerResponseContext>(){

                        public JerseyContainerResponseContext apply(JerseyContainerResponseContext responseContext) {
                            responseContext.getRequestContext().setMethod("HEAD");
                            return responseContext;
                        }
                    });
                }
                return Router.Continuation.of(requestContext, MethodSelectingRouter.this.getMethodRouter(requestContext));
            }
        };
    }

    private ConsumesProducesAcceptor createPlainTextOptionsInflector(final Set<String> allowedMethods) {
        String allowedList = allowedMethods.toString();
        final String optionsBody = allowedList.substring(1, allowedList.length() - 1);
        return new ConsumesProducesAcceptor(new CombinedClientServerMediaType.EffectiveMediaType(MediaType.WILDCARD_TYPE, false), new CombinedClientServerMediaType.EffectiveMediaType(MediaType.TEXT_PLAIN_TYPE, false), new MethodAcceptorPair(null, Routers.asTreeAcceptor(new Inflector<JerseyContainerRequestContext, JerseyContainerResponseContext>(){

            public JerseyContainerResponseContext apply(JerseyContainerRequestContext requestContext) {
                Response response = Response.ok((Object)optionsBody, (MediaType)MediaType.TEXT_PLAIN_TYPE).allow(allowedMethods).build();
                return new JerseyContainerResponseContext(requestContext, response);
            }
        })));
    }

    private ConsumesProducesAcceptor createGenericOptionsInflector(final Set<String> allowedMethods) {
        return new ConsumesProducesAcceptor(new CombinedClientServerMediaType.EffectiveMediaType(MediaType.WILDCARD_TYPE, false), new CombinedClientServerMediaType.EffectiveMediaType(MediaType.WILDCARD_TYPE, false), new MethodAcceptorPair(null, Routers.asTreeAcceptor(new Inflector<JerseyContainerRequestContext, JerseyContainerResponseContext>(){

            public JerseyContainerResponseContext apply(JerseyContainerRequestContext requestContext) {
                Response response = Response.ok().allow(allowedMethods).header("Content-Length", (Object)"0").type(requestContext.getAcceptableMediaTypes().get(0)).build();
                return new JerseyContainerResponseContext(requestContext, response);
            }
        })));
    }

    private static class MethodSelector {
        RequestSpecificConsumesProducesAcceptor selected;
        List<RequestSpecificConsumesProducesAcceptor> sameFitnessAcceptors;

        MethodSelector(RequestSpecificConsumesProducesAcceptor i) {
            this.selected = i;
            this.sameFitnessAcceptors = null;
        }

        void consider(RequestSpecificConsumesProducesAcceptor i) {
            int theGreaterTheBetter = i.compareTo(this.selected);
            if (theGreaterTheBetter > 0) {
                this.selected = i;
                this.sameFitnessAcceptors = null;
            } else if (theGreaterTheBetter == 0 && this.selected.methodAcceptorPair != i.methodAcceptorPair) {
                this.getSameFitnessList().add(i);
            }
        }

        List<RequestSpecificConsumesProducesAcceptor> getSameFitnessList() {
            if (this.sameFitnessAcceptors == null) {
                this.sameFitnessAcceptors = new LinkedList<RequestSpecificConsumesProducesAcceptor>();
            }
            return this.sameFitnessAcceptors;
        }
    }

    private static class RequestSpecificConsumesProducesAcceptor
    implements Comparable {
        CombinedClientServerMediaType consumes;
        CombinedClientServerMediaType produces;
        MethodAcceptorPair methodAcceptorPair;

        RequestSpecificConsumesProducesAcceptor(CombinedClientServerMediaType consumes, CombinedClientServerMediaType produces, MethodAcceptorPair methodAcceptorPair) {
            this.methodAcceptorPair = methodAcceptorPair;
            this.consumes = consumes;
            this.produces = produces;
        }

        public String toString() {
            return String.format("%s->%s:%s", this.consumes, this.produces, this.methodAcceptorPair);
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            if (!(o instanceof RequestSpecificConsumesProducesAcceptor)) {
                return 1;
            }
            RequestSpecificConsumesProducesAcceptor other = (RequestSpecificConsumesProducesAcceptor)o;
            int consumedComparison = CombinedClientServerMediaType.COMPARATOR.compare(this.consumes, other.consumes);
            return consumedComparison != 0 ? consumedComparison : CombinedClientServerMediaType.COMPARATOR.compare(this.produces, other.produces);
        }
    }

    private static class ConsumesProducesAcceptor {
        private CombinedClientServerMediaType.EffectiveMediaType consumes;
        private CombinedClientServerMediaType.EffectiveMediaType produces;
        private MethodAcceptorPair methodAcceptorPair;

        private ConsumesProducesAcceptor(CombinedClientServerMediaType.EffectiveMediaType consumes, CombinedClientServerMediaType.EffectiveMediaType produces, MethodAcceptorPair methodAcceptorPair) {
            this.methodAcceptorPair = methodAcceptorPair;
            this.consumes = consumes;
            this.produces = produces;
        }

        public CombinedClientServerMediaType.EffectiveMediaType getConsumes() {
            return this.consumes;
        }

        public CombinedClientServerMediaType.EffectiveMediaType getProduces() {
            return this.produces;
        }

        boolean isConsumable(JerseyContainerRequestContext requestContext) {
            MediaType contentType = requestContext.getMediaType();
            return contentType == null || this.consumes.getMediaType().isCompatible(contentType);
        }

        public String toString() {
            return String.format("%s->%s:%s", this.consumes.getMediaType(), this.produces.getMediaType(), this.methodAcceptorPair);
        }
    }

    static class Builder {
        @Inject
        private Factory<ResponseProcessor.RespondingContext<JerseyContainerResponseContext>> respondingContextFactory;

        Builder() {
        }

        public MethodSelectingRouter build(MessageBodyWorkers workers, List<MethodAcceptorPair> methodAcceptorPairs) {
            return new MethodSelectingRouter(this.respondingContextFactory, workers, methodAcceptorPairs);
        }
    }
}

