/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.List;
import java.util.regex.MatchResult;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.internal.routing.Route;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.uri.PathPattern;
import org.jvnet.hk2.annotations.Inject;

class PathPatternRouter
implements Router {
    private final Factory<RoutingContext> contextProvider;
    private final List<Route<PathPattern>> acceptedRoutes;

    private PathPatternRouter(Factory<RoutingContext> provider, List<Route<PathPattern>> routes) {
        this.contextProvider = provider;
        this.acceptedRoutes = routes;
    }

    @Override
    public Router.Continuation apply(JerseyContainerRequestContext request) {
        RoutingContext rc = (RoutingContext)this.contextProvider.get();
        String path = rc.getFinalMatchingGroup();
        for (Route<PathPattern> acceptedRoute : this.acceptedRoutes) {
            MatchResult m = acceptedRoute.routingPattern().match((CharSequence)path);
            if (m == null) continue;
            rc.pushMatchResult(m);
            rc.pushTemplate(acceptedRoute.routingPattern().getTemplate());
            return Router.Continuation.of(request, acceptedRoute.next());
        }
        return Router.Continuation.of(request);
    }

    public static class Builder {
        @Inject
        private Factory<RoutingContext> contextProvider;

        public PathPatternRouter build(List<Route<PathPattern>> routes) {
            return new PathPatternRouter(this.contextProvider, routes);
        }
    }
}

