/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import org.glassfish.hk2.Factory;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.model.MethodHandler;
import org.jvnet.hk2.annotations.Inject;

class PushMethodHandlerRouter
implements Router {
    private final Injector injector;
    private final Factory<RoutingContext> routingContextFactory;
    private final MethodHandler methodHandler;
    private final Router next;

    private PushMethodHandlerRouter(Injector injector, Factory<RoutingContext> routingContextFactory, MethodHandler methodHandler, Router next) {
        this.injector = injector;
        this.routingContextFactory = routingContextFactory;
        this.methodHandler = methodHandler;
        this.next = next;
    }

    @Override
    public Router.Continuation apply(JerseyContainerRequestContext request) {
        Object handlerInstance = this.methodHandler.getInstance(this.injector);
        ((RoutingContext)this.routingContextFactory.get()).pushMatchedResource(handlerInstance);
        return Router.Continuation.of(request, this.next);
    }

    static class Builder {
        @Inject
        private Factory<RoutingContext> routingContextFactory;
        @Inject
        private Injector injector;

        Builder() {
        }

        public PushMethodHandlerRouter build(MethodHandler methodHandler, Router next) {
            return new PushMethodHandlerRouter(this.injector, this.routingContextFactory, methodHandler, next);
        }
    }
}

