/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.server.internal.routing.Router;

final class Route<T> {
    private static final Function<Factory<Router>, Router> PROVIDER_TO_ROUTER_TRANSFORMATION = new Function<Factory<Router>, Router>(){

        public Router apply(Factory<Router> f) {
            return (Router)f.get();
        }
    };
    private final T routingPattern;
    private final List<Factory<Router>> routerProviders;

    static <T> Route<T> of(T routingPattern, List<Factory<Router>> routerProviders) {
        return new Route<T>(routingPattern, routerProviders);
    }

    private Route(T routingPattern, List<Factory<Router>> routerProviders) {
        this.routingPattern = routingPattern;
        this.routerProviders = routerProviders;
    }

    public T routingPattern() {
        return this.routingPattern;
    }

    public List<Router> next() {
        if (this.routerProviders.isEmpty()) {
            return Collections.emptyList();
        }
        return Lists.transform(this.routerProviders, PROVIDER_TO_ROUTER_TRANSFORMATION);
    }
}

