/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.base.Function;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.Inflecting;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.JerseyContainerResponseContext;
import org.glassfish.jersey.server.internal.routing.Router;

class Routers {
    private Routers() {
    }

    public static Router asTreeAcceptor(Inflector<JerseyContainerRequestContext, JerseyContainerResponseContext> inflector) {
        return new InflectingRouter(inflector);
    }

    public static Router.Builder acceptingTree(Function<JerseyContainerRequestContext, JerseyContainerRequestContext> transformation) {
        return new RouterBuilder(transformation);
    }

    private static class LinkedRouter
    implements Router {
        private final Function<JerseyContainerRequestContext, JerseyContainerRequestContext> transformation;
        private final List<Router> children;

        public LinkedRouter(Function<JerseyContainerRequestContext, JerseyContainerRequestContext> transformation, List<Router> children) {
            this.transformation = transformation;
            this.children = children;
        }

        public LinkedRouter(Function<JerseyContainerRequestContext, JerseyContainerRequestContext> transformation) {
            this.transformation = transformation;
            this.children = Collections.emptyList();
        }

        @Override
        public Router.Continuation apply(JerseyContainerRequestContext data) {
            return Router.Continuation.of((JerseyContainerRequestContext)((Object)this.transformation.apply((Object)data)), this.children);
        }
    }

    private static class RouterBuilder
    implements Router.Builder {
        private final Function<JerseyContainerRequestContext, JerseyContainerRequestContext> transformation;
        private List<Router> children;

        public RouterBuilder(Function<JerseyContainerRequestContext, JerseyContainerRequestContext> transformation) {
            this.transformation = transformation;
        }

        @Override
        public Router.Builder child(Router child) {
            if (this.children == null) {
                this.children = new LinkedList<Router>();
            }
            this.children.add(child);
            return this;
        }

        @Override
        public Router build() {
            return this.children == null ? new LinkedRouter(this.transformation) : new LinkedRouter(this.transformation, this.children);
        }
    }

    private static class InflectingRouter
    implements Router,
    Inflecting<JerseyContainerRequestContext, JerseyContainerResponseContext> {
        private final Inflector<JerseyContainerRequestContext, JerseyContainerResponseContext> inflector;

        public InflectingRouter(Inflector<JerseyContainerRequestContext, JerseyContainerResponseContext> inflector) {
            this.inflector = inflector;
        }

        public Inflector<JerseyContainerRequestContext, JerseyContainerResponseContext> inflector() {
            return this.inflector;
        }

        @Override
        public Router.Continuation apply(JerseyContainerRequestContext request) {
            return Router.Continuation.of(request);
        }
    }
}

