/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import org.glassfish.hk2.Factory;
import org.glassfish.jersey.process.internal.AbstractChainableStage;
import org.glassfish.jersey.process.internal.Inflecting;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.JerseyContainerResponseContext;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.internal.routing.TransformableData;
import org.jvnet.hk2.annotations.Inject;

public class RoutingStage
extends AbstractChainableStage<JerseyContainerRequestContext> {
    private final Router routingRoot;
    private final Factory<RoutingContext> routingContextFactory;

    private RoutingStage(Router routingRoot, Factory<RoutingContext> routingContextFactory) {
        this.routingRoot = routingRoot;
        this.routingContextFactory = routingContextFactory;
    }

    public Stage.Continuation<JerseyContainerRequestContext> apply(JerseyContainerRequestContext request) {
        TransformableData<JerseyContainerRequestContext, JerseyContainerResponseContext> result = this._apply(request, this.routingRoot);
        if (result.hasInflector()) {
            ((RoutingContext)this.routingContextFactory.get()).setInflector(result.inflector());
        }
        return Stage.Continuation.of((Object)((Object)result.data()), (Stage)this.getDefaultNext());
    }

    private TransformableData<JerseyContainerRequestContext, JerseyContainerResponseContext> _apply(JerseyContainerRequestContext request, Router router) {
        Router.Continuation continuation = router.apply(request);
        for (Router child : continuation.next()) {
            TransformableData<JerseyContainerRequestContext, JerseyContainerResponseContext> result = this._apply(continuation.requestContext(), child);
            if (!result.hasInflector()) continue;
            return result;
        }
        if (router instanceof Inflecting) {
            return TransformableData.of(continuation.requestContext(), ((Inflecting)router).inflector());
        }
        return TransformableData.of(continuation.requestContext());
    }

    public static class Builder {
        @Inject
        private Factory<RoutingContext> routingContextFactory;

        public RoutingStage build(Router routingRoot) {
            return new RoutingStage(routingRoot, this.routingContextFactory);
        }
    }
}

