/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.JerseyContainerResponseContext;
import org.glassfish.jersey.server.internal.routing.MethodAcceptorPair;
import org.glassfish.jersey.server.internal.routing.MethodSelectingRouter;
import org.glassfish.jersey.server.internal.routing.PushMatchedUriRouter;
import org.glassfish.jersey.server.internal.routing.PushMethodHandlerRouter;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.internal.routing.Routers;
import org.glassfish.jersey.server.internal.routing.SubResourceLocatorRouter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodInvoker;
import org.glassfish.jersey.uri.PathPattern;
import org.jvnet.hk2.annotations.Inject;

public final class RuntimeModelBuilder {
    @Inject
    private RouterModule.RootRouteBuilder<PathPattern> rootBuilder;
    @Inject
    private ResourceMethodInvoker.Builder resourceMethodInvokerBuilder;
    @Inject
    private Injector injector;
    @Inject
    private Services services;
    @Inject
    private PushMethodHandlerRouter.Builder pushHandlerAcceptorBuilder;
    @Inject
    private MethodSelectingRouter.Builder methodSelectingAcceptorBuilder;
    private MessageBodyWorkers workers;
    private boolean subResourceMode;
    private TreeMap<PathPattern, List<MethodAcceptorPair>> rootAcceptors = Maps.newTreeMap((Comparator)PathPattern.COMPARATOR);
    private TreeMap<PathPattern, TreeMap<PathPattern, List<MethodAcceptorPair>>> subResourceAcceptors = Maps.newTreeMap((Comparator)PathPattern.COMPARATOR);

    public RuntimeModelBuilder() {
        this(null, false);
    }

    public RuntimeModelBuilder(MessageBodyWorkers workers, boolean subResourceMode) {
        this.workers = workers;
        this.subResourceMode = subResourceMode;
    }

    public void process(Resource resource) {
        if (!resource.isRootResource() && !this.subResourceMode) {
            return;
        }
        if (!resource.getResourceMethods().isEmpty()) {
            PathPattern closedResourcePathPattern = this.subResourceMode ? PathPattern.END_OF_PATH_PATTERN : PathPattern.asClosed((PathPattern)resource.getPathPattern());
            LinkedList sameResourcePathList = this.rootAcceptors.get(closedResourcePathPattern);
            if (sameResourcePathList == null) {
                sameResourcePathList = Lists.newLinkedList();
                this.rootAcceptors.put(closedResourcePathPattern, sameResourcePathList);
            }
            sameResourcePathList.addAll(Lists.transform(resource.getResourceMethods(), (Function)new Function<ResourceMethod, MethodAcceptorPair>(){

                public MethodAcceptorPair apply(ResourceMethod methodModel) {
                    return new MethodAcceptorPair(methodModel, RuntimeModelBuilder.this.createSingleMethodAcceptor(methodModel));
                }
            }));
        }
        if (resource.getSubResourceMethods().size() + resource.getSubResourceLocators().size() > 0) {
            PathPattern openResourcePathPattern = this.subResourceMode ? PathPattern.OPEN_ROOT_PATH_PATTERN : resource.getPathPattern();
            TreeMap sameResourcePathMap = this.subResourceAcceptors.get(openResourcePathPattern);
            if (sameResourcePathMap == null) {
                sameResourcePathMap = Maps.newTreeMap((Comparator)PathPattern.COMPARATOR);
                this.subResourceAcceptors.put(openResourcePathPattern, sameResourcePathMap);
            }
            for (ResourceMethod methodModel : resource.getSubResourceMethods()) {
                this.updateSubResourceMethodMap(sameResourcePathMap, methodModel);
            }
            for (ResourceMethod methodModel : resource.getSubResourceLocators()) {
                this.updateSubResourceMethodMap(sameResourcePathMap, methodModel);
            }
        }
    }

    private void updateSubResourceMethodMap(TreeMap<PathPattern, List<MethodAcceptorPair>> subResourceMethodMap, ResourceMethod methodModel) {
        PathPattern openMethodPattern = new PathPattern(methodModel.getPath());
        LinkedList samePathMethodAcceptorPairs = subResourceMethodMap.get(openMethodPattern);
        if (samePathMethodAcceptorPairs == null) {
            samePathMethodAcceptorPairs = Lists.newLinkedList();
            subResourceMethodMap.put(openMethodPattern, samePathMethodAcceptorPairs);
        }
        samePathMethodAcceptorPairs.add(new MethodAcceptorPair(methodModel, this.createSingleMethodAcceptor(methodModel)));
    }

    private Router createSingleMethodAcceptor(ResourceMethod resourceMethod) {
        Router methodAcceptor = null;
        switch (resourceMethod.getType()) {
            case RESOURCE_METHOD: 
            case SUB_RESOURCE_METHOD: {
                methodAcceptor = Routers.asTreeAcceptor(this.createInflector(resourceMethod));
                break;
            }
            case SUB_RESOURCE_LOCATOR: {
                methodAcceptor = new SubResourceLocatorRouter(this.injector, this.services, this.workers, resourceMethod);
            }
        }
        if (this.subResourceMode) {
            return methodAcceptor;
        }
        return this.pushHandlerAcceptorBuilder.build(resourceMethod.getInvocable().getHandler(), methodAcceptor);
    }

    private Inflector<JerseyContainerRequestContext, JerseyContainerResponseContext> createInflector(ResourceMethod method) {
        return this.resourceMethodInvokerBuilder.build(method);
    }

    private Router createRootTreeAcceptor(RouterModule.RouteToPathBuilder<PathPattern> lastRoutedBuilder) {
        Router routingRoot = lastRoutedBuilder != null ? lastRoutedBuilder.build() : Routers.acceptingTree(new Function<JerseyContainerRequestContext, JerseyContainerRequestContext>(){

            public JerseyContainerRequestContext apply(JerseyContainerRequestContext input) {
                return input;
            }
        }).build();
        if (this.subResourceMode) {
            return routingRoot;
        }
        return this.rootBuilder.root(routingRoot);
    }

    private RouterModule.RouteToPathBuilder<PathPattern> routeMethodAcceptor(RouterModule.RouteToPathBuilder<PathPattern> lastRoutedBuilder, PathPattern pathPattern, Router uriPushingAcceptor, Router methodAcceptor) {
        if (this.subResourceMode) {
            return this.routedBuilder(lastRoutedBuilder).route(pathPattern).to(methodAcceptor);
        }
        return this.routedBuilder(lastRoutedBuilder).route(pathPattern).to(uriPushingAcceptor).to(methodAcceptor);
    }

    public Router buildModel() {
        PushMatchedUriRouter uriPushingRouter = (PushMatchedUriRouter)this.injector.inject(PushMatchedUriRouter.class);
        RouterModule.RouteToPathBuilder<PathPattern> lastRoutedBuilder = null;
        if (!this.rootAcceptors.isEmpty()) {
            for (Map.Entry<PathPattern, List<MethodAcceptorPair>> entry : this.rootAcceptors.entrySet()) {
                PathPattern closedResourcePathPattern = entry.getKey();
                List<MethodAcceptorPair> methodAcceptorPairs = entry.getValue();
                lastRoutedBuilder = this.routeMethodAcceptor(lastRoutedBuilder, closedResourcePathPattern, uriPushingRouter, this.methodSelectingAcceptorBuilder.build(this.workers, methodAcceptorPairs));
            }
            this.rootAcceptors.clear();
        }
        if (!this.subResourceAcceptors.isEmpty()) {
            for (Map.Entry<PathPattern, Object> entry : this.subResourceAcceptors.entrySet()) {
                RouterModule.RouteToPathBuilder srRoutedBuilder = null;
                for (Map.Entry singlePathEntry : ((TreeMap)entry.getValue()).entrySet()) {
                    LinkedList subResourceMethods = Lists.newLinkedList();
                    MethodAcceptorPair locator = null;
                    for (MethodAcceptorPair methodAcceptorPair : (List)singlePathEntry.getValue()) {
                        if (methodAcceptorPair.model.getType() == ResourceMethod.JaxrsType.SUB_RESOURCE_METHOD) {
                            subResourceMethods.add(methodAcceptorPair);
                            continue;
                        }
                        locator = methodAcceptorPair;
                    }
                    if (!subResourceMethods.isEmpty()) {
                        PathPattern subResourceMethodPath = PathPattern.asClosed((PathPattern)((PathPattern)singlePathEntry.getKey()));
                        srRoutedBuilder = this.routedBuilder(srRoutedBuilder).route(subResourceMethodPath).to(uriPushingRouter).to(this.methodSelectingAcceptorBuilder.build(this.workers, subResourceMethods));
                    }
                    if (locator == null) continue;
                    srRoutedBuilder = this.routedBuilder(srRoutedBuilder).route((PathPattern)singlePathEntry.getKey()).to(uriPushingRouter).to(locator.router);
                }
                assert (srRoutedBuilder != null);
                lastRoutedBuilder = this.routeMethodAcceptor(lastRoutedBuilder, entry.getKey(), uriPushingRouter, srRoutedBuilder.build());
            }
            this.subResourceAcceptors.clear();
        }
        return this.createRootTreeAcceptor(lastRoutedBuilder);
    }

    private RouterModule.RouteBuilder<PathPattern> routedBuilder(RouterModule.RouteToPathBuilder<PathPattern> lastRoutedBuilder) {
        return lastRoutedBuilder == null ? this.rootBuilder : lastRoutedBuilder;
    }

    public void setWorkers(MessageBodyWorkers workers) {
        this.workers = workers;
    }
}

