/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.MappableException;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.spi.internal.ParameterValueHelper;

class SubResourceLocatorRouter
implements Router {
    private final Services services;
    private final Injector injector;
    private final ResourceMethod locatorModel;
    private final List<Factory<?>> valueProviders;
    private final RuntimeModelBuilder runtimeModelBuilder;

    public SubResourceLocatorRouter(Injector injector, Services services, MessageBodyWorkers workers, ResourceMethod locatorModel) {
        this.injector = injector;
        this.services = services;
        this.locatorModel = locatorModel;
        this.valueProviders = ParameterValueHelper.createValueProviders(services, locatorModel.getInvocable());
        this.runtimeModelBuilder = new RuntimeModelBuilder(workers, true);
        this.injector.inject((Object)this.runtimeModelBuilder);
    }

    @Override
    public Router.Continuation apply(JerseyContainerRequestContext request) {
        RoutingContext routingCtx = (RoutingContext)this.injector.inject(RoutingContext.class);
        Object subResource = this.getResource(routingCtx);
        if (subResource == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (subResource.getClass().isAssignableFrom(Class.class)) {
            subResource = this.services.forContract((Class)subResource).get();
        }
        Resource subResourceModel = Resource.builder(subResource, new LinkedList<ResourceModelIssue>()).build();
        this.runtimeModelBuilder.process(subResourceModel);
        routingCtx.pushMatchedResource(subResource);
        Router subResourceAcceptor = this.runtimeModelBuilder.buildModel();
        return Router.Continuation.of(request, subResourceAcceptor);
    }

    private Object getResource(RoutingContext routingCtx) {
        Object resource = routingCtx.peekMatchedResource();
        try {
            Method handlingMethod = this.locatorModel.getInvocable().getHandlingMethod();
            return handlingMethod.invoke(resource, ParameterValueHelper.getParameterValues(this.valueProviders));
        }
        catch (IllegalAccessException ex) {
            throw new ProcessingException("Resource Java method invocation error.", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ProcessingException) {
                throw (ProcessingException)cause;
            }
            throw new MappableException(cause);
        }
        catch (UndeclaredThrowableException ex) {
            throw new ProcessingException("Resource Java method invocation error.", (Throwable)ex);
        }
        catch (ProcessingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MappableException((Throwable)ex);
        }
        catch (Throwable t) {
            throw new ProcessingException(t);
        }
    }
}

