/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.JerseyContainerResponseContext;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.uri.ExtendedUriInfo;
import org.glassfish.jersey.uri.UriComponent;
import org.glassfish.jersey.uri.UriTemplate;
import org.glassfish.jersey.uri.internal.UriBuilderImpl;
import org.jvnet.hk2.annotations.Inject;

class UriRoutingContext
implements RoutingContext,
ExtendedUriInfo {
    private final LinkedList<MatchResult> matchResults = Lists.newLinkedList();
    private final LinkedList<Object> matchedResources = Lists.newLinkedList();
    private final LinkedList<UriTemplate> templates = Lists.newLinkedList();
    private MultivaluedHashMap<String, String> encodedTemplateValues;
    private MultivaluedHashMap<String, String> decodedTemplateValues;
    private final LinkedList<String> paths = Lists.newLinkedList();
    private Inflector<JerseyContainerRequestContext, JerseyContainerResponseContext> inflector = null;
    private Ref<JerseyContainerRequestContext> requestContext;

    UriRoutingContext(@Inject Ref<JerseyContainerRequestContext> requestContext) {
        this.requestContext = requestContext;
    }

    @Override
    public void pushMatchResult(MatchResult matchResult) {
        this.matchResults.push(matchResult);
    }

    @Override
    public void pushMatchedResource(Object resource) {
        this.matchedResources.push(resource);
    }

    @Override
    public Object peekMatchedResource() {
        return this.matchedResources.peek();
    }

    @Override
    public void pushLeftHandPath() {
        String rightHandPath = this.getFinalMatchingGroup();
        int rhpLength = rightHandPath != null ? rightHandPath.length() : 0;
        String encodedRequestPath = this.getAbsolutePath().toString();
        if (encodedRequestPath.length() != rhpLength) {
            int startIndex = encodedRequestPath.length() > 1 && encodedRequestPath.charAt(0) == '/' ? 1 : 0;
            this.paths.addFirst(encodedRequestPath.substring(startIndex, encodedRequestPath.length() - rhpLength));
        }
    }

    @Override
    public void pushTemplate(UriTemplate template) {
        this.templates.addFirst(template);
        if (this.encodedTemplateValues == null) {
            this.encodedTemplateValues = new MultivaluedHashMap();
        }
        MatchResult matchResult = this.peekMatchResult();
        int i = 1;
        for (String templateVariable : template.getTemplateVariables()) {
            String value = matchResult.group(i++);
            this.encodedTemplateValues.addFirst((Object)templateVariable, (Object)value);
            if (this.decodedTemplateValues == null) continue;
            this.decodedTemplateValues.addFirst((Object)UriComponent.decode((String)templateVariable, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT), (Object)UriComponent.decode((String)value, (UriComponent.Type)UriComponent.Type.PATH));
        }
    }

    @Override
    public MatchResult peekMatchResult() {
        return this.matchResults.peek();
    }

    @Override
    public String getFinalMatchingGroup() {
        MatchResult mr = this.matchResults.peek();
        if (mr == null) {
            return null;
        }
        String finalGroup = mr.group(mr.groupCount());
        return finalGroup == null ? "" : finalGroup;
    }

    public LinkedList<MatchResult> getMatchedResults() {
        return this.matchResults;
    }

    @Override
    public void setInflector(Inflector<JerseyContainerRequestContext, JerseyContainerResponseContext> inflector) {
        this.inflector = inflector;
    }

    @Override
    public Inflector<JerseyContainerRequestContext, JerseyContainerResponseContext> getInflector() {
        return this.inflector;
    }

    public URI getAbsolutePath() {
        return URI.create(this.getEncodedPath());
    }

    public UriBuilder getAbsolutePathBuilder() {
        return new UriBuilderImpl().uri(this.getAbsolutePath());
    }

    public URI getBaseUri() {
        return ((JerseyContainerRequestContext)((Object)this.requestContext.get())).getBaseUri();
    }

    public UriBuilder getBaseUriBuilder() {
        return new UriBuilderImpl().uri(this.getBaseUri());
    }

    public List<Object> getMatchedResources() {
        return Collections.unmodifiableList(this.matchedResources);
    }

    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    public List<String> getMatchedURIs(boolean decode) {
        List<String> result = decode ? Lists.transform(this.paths, (Function)new Function<String, String>(){

            public String apply(String input) {
                return UriComponent.decode((String)input, (UriComponent.Type)UriComponent.Type.PATH);
            }
        }) : this.paths;
        return Collections.unmodifiableList(result);
    }

    public String getPath() {
        return ((JerseyContainerRequestContext)((Object)this.requestContext.get())).getPath(true);
    }

    public String getPath(boolean decode) {
        return ((JerseyContainerRequestContext)((Object)this.requestContext.get())).getPath(decode);
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (decode) {
            if (this.decodedTemplateValues != null) {
                return this.decodedTemplateValues;
            }
            this.decodedTemplateValues = new MultivaluedHashMap();
            for (Map.Entry e : this.encodedTemplateValues.entrySet()) {
                this.decodedTemplateValues.put((Object)UriComponent.decode((String)((String)e.getKey()), (UriComponent.Type)UriComponent.Type.PATH_SEGMENT), new LinkedList(Lists.transform((List)((List)e.getValue()), (Function)new Function<String, String>(){

                    public String apply(String input) {
                        return UriComponent.decode((String)input, (UriComponent.Type)UriComponent.Type.PATH);
                    }
                })));
            }
            return this.decodedTemplateValues;
        }
        return this.encodedTemplateValues;
    }

    private String getEncodedPath() {
        URI requestUri = this.getRequestUri();
        String rp = requestUri.toString();
        String qrp = requestUri.getRawQuery();
        return qrp == null ? rp : rp.substring(0, rp.length() - qrp.length() - 1);
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        String ep = this.getEncodedPath();
        String base = this.getBaseUri().toString();
        return UriComponent.decodePath((String)ep.substring(base.length()), (boolean)decode);
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return UriComponent.decodeQuery((URI)this.getRequestUri(), (boolean)false);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        return UriComponent.decodeQuery((URI)this.getRequestUri(), (boolean)true);
    }

    public URI getRequestUri() {
        return ((JerseyContainerRequestContext)((Object)this.requestContext.get())).getRequestUri();
    }

    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri((URI)this.getRequestUri());
    }

    public Throwable getMappedThrowable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<UriTemplate> getMatchedTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public List<PathSegment> getPathSegments(String name) {
        return this.getPathSegments(name, true);
    }

    public List<PathSegment> getPathSegments(String name, boolean decode) {
        int[] bounds = this.getPathParameterBounds(name);
        if (bounds != null) {
            String path = this.matchResults.getLast().group();
            int segmentsStart = 0;
            for (int x = 0; x < bounds[0]; ++x) {
                if (path.charAt(x) != '/') continue;
                ++segmentsStart;
            }
            int segmentsEnd = segmentsStart;
            for (int x = bounds[0]; x < bounds[1]; ++x) {
                if (path.charAt(x) != '/') continue;
                ++segmentsEnd;
            }
            return this.getPathSegments(decode).subList(segmentsStart - 1, segmentsEnd);
        }
        return Collections.emptyList();
    }

    private int[] getPathParameterBounds(String name) {
        Iterator templatesIterator = this.templates.iterator();
        Iterator matchResultsIterator = this.matchResults.iterator();
        while (templatesIterator.hasNext()) {
            MatchResult mr = (MatchResult)matchResultsIterator.next();
            int pIndex = this.getLastPathParameterIndex(name, (UriTemplate)templatesIterator.next());
            if (pIndex == -1) continue;
            int pathLength = mr.group().length();
            int segmentIndex = mr.end(pIndex + 1);
            int groupLength = segmentIndex - mr.start(pIndex + 1);
            while (matchResultsIterator.hasNext()) {
                mr = (MatchResult)matchResultsIterator.next();
                segmentIndex += mr.group().length() - pathLength;
                pathLength = mr.group().length();
            }
            return new int[]{segmentIndex - groupLength, segmentIndex};
        }
        return null;
    }

    private int getLastPathParameterIndex(String name, UriTemplate t) {
        int i = 0;
        int pIndex = -1;
        for (String parameterName : t.getTemplateVariables()) {
            if (parameterName.equals(name)) {
                pIndex = i;
            }
            ++i;
        }
        return pIndex;
    }
}

