/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.JerseyContainerResponseContext;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodDispatcherFactory;
import org.glassfish.jersey.server.model.ResourceMethodInvocationHandlerFactory;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;
import org.jvnet.hk2.annotations.Inject;

public class ResourceMethodInvoker
implements Inflector<JerseyContainerRequestContext, JerseyContainerResponseContext> {
    private final Factory<RoutingContext> routingContextFactory;
    private final Factory<InvocationContext> invocationContextFactory;
    private final ResourceMethod method;
    private final ResourceMethodDispatcher dispatcher;

    private ResourceMethodInvoker(Factory<RoutingContext> routingContextFactory, Factory<InvocationContext> invocationContextFactory, ResourceMethodDispatcher.Provider dispatcherProvider, ResourceMethodInvocationHandlerProvider invocationHandlerProvider, ResourceMethod method) {
        this.routingContextFactory = routingContextFactory;
        this.invocationContextFactory = invocationContextFactory;
        this.method = method;
        Invocable invocable = method.getInvocable();
        this.dispatcher = dispatcherProvider.create(invocable, invocationHandlerProvider.create(invocable));
    }

    public JerseyContainerResponseContext apply(JerseyContainerRequestContext requestContext) {
        Type invocableType;
        Object resource = ((RoutingContext)this.routingContextFactory.get()).peekMatchedResource();
        InvocationContext invocationCtx = (InvocationContext)this.invocationContextFactory.get();
        if (this.method.isSuspendDeclared()) {
            invocationCtx.setSuspendTimeout(this.method.getSuspendTimeout(), this.method.getSuspendTimeoutUnit());
        }
        Response response = this.dispatcher.dispatch(resource, requestContext);
        if (this.method.isSuspendDeclared()) {
            invocationCtx.setResponse(resource);
            invocationCtx.trySuspend();
        }
        JerseyContainerResponseContext responseContext = new JerseyContainerResponseContext(requestContext, response);
        Invocable invocable = this.method.getInvocable();
        responseContext.setEntityAnnotations(invocable.getHandlingMethod().getDeclaredAnnotations());
        if (responseContext.hasEntity() && !(responseContext.getEntityType() instanceof ParameterizedType) && (invocableType = invocable.getResponseType()) != null && Void.TYPE != invocableType && Void.class != invocableType && invocableType != Response.class) {
            responseContext.setEntityType(invocableType);
        }
        return responseContext;
    }

    public String toString() {
        return this.method.getInvocable().getHandlingMethod().toString();
    }

    public static class Builder {
        @Inject
        private Factory<RoutingContext> routingContextFactory;
        @Inject
        private Factory<InvocationContext> invocationContextFactory;
        @Inject
        private ResourceMethodDispatcherFactory dispatcherProviderFactory;
        @Inject
        private ResourceMethodInvocationHandlerFactory invocationHandlerProviderFactory;

        public ResourceMethodInvoker build(ResourceMethod method) {
            return new ResourceMethodInvoker(this.routingContextFactory, this.invocationContextFactory, this.dispatcherProviderFactory, this.invocationHandlerProviderFactory, method);
        }
    }
}

