/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Request;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.AbstractHttpContextValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.HttpContext;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
class EntityParamValueFactoryProvider
extends AbstractValueFactoryProvider<Annotation> {
    @Inject
    EntityParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator injector) {
        super(mpep, injector, Parameter.Source.ENTITY);
    }

    @Override
    protected Factory<?> createValueFactory(Parameter parameter) {
        return new EntityValueFactory(parameter);
    }

    private static class EntityValueFactory
    extends AbstractHttpContextValueFactory<Object> {
        private final Parameter parameter;

        public EntityValueFactory(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        protected Object get(HttpContext context) {
            ContainerRequest requestContext = context.getRequestContext();
            Class<?> rawType = this.parameter.getRawType();
            return (Request.class.isAssignableFrom(rawType) || ContainerRequestContext.class.isAssignableFrom(rawType)) && rawType.isInstance((Object)requestContext) ? requestContext : requestContext.readEntity(rawType, this.parameter.getType(), this.parameter.getAnnotations());
        }
    }
}

