/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicBinder;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.routing.MethodAcceptorPair;
import org.glassfish.jersey.server.internal.routing.MethodSelectingRouter;
import org.glassfish.jersey.server.internal.routing.PushMatchedUriRouter;
import org.glassfish.jersey.server.internal.routing.PushMethodHandlerRouter;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RouterBinder;
import org.glassfish.jersey.server.internal.routing.Routers;
import org.glassfish.jersey.server.internal.routing.SingletonResourceBinder;
import org.glassfish.jersey.server.internal.routing.SubResourceLocatorRouter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodInvoker;
import org.glassfish.jersey.uri.PathPattern;

public final class RuntimeModelBuilder {
    @Inject
    private RouterBinder.RootRouteBuilder<PathPattern> rootBuilder;
    @Inject
    private ResourceMethodInvoker.Builder resourceMethodInvokerBuilder;
    @Inject
    private ServiceLocator locator;
    @Inject
    private PushMethodHandlerRouter.Builder pushHandlerAcceptorBuilder;
    @Inject
    private MethodSelectingRouter.Builder methodSelectingAcceptorBuilder;
    @Inject
    private SingletonResourceBinder resourceProvider;
    private MessageBodyWorkers workers;
    private MultivaluedMap<Class<? extends Annotation>, ContainerRequestFilter> nameBoundRequestFilters;
    private MultivaluedMap<Class<? extends Annotation>, ContainerResponseFilter> nameBoundResponseFilters;
    private Collection<ReaderInterceptor> globalReaderInterceptors;
    private Collection<WriterInterceptor> globalWriterInterceptors;
    private MultivaluedMap<Class<? extends Annotation>, ReaderInterceptor> nameBoundReaderInterceptors;
    private MultivaluedMap<Class<? extends Annotation>, WriterInterceptor> nameBoundWriterInterceptors;
    private List<DynamicBinder> dynamicBinders;
    private TreeMap<PathPattern, List<MethodAcceptorPair>> rootAcceptors = Maps.newTreeMap((Comparator)PathPattern.COMPARATOR);
    private TreeMap<PathPattern, TreeMap<PathPattern, List<MethodAcceptorPair>>> subResourceAcceptors = Maps.newTreeMap((Comparator)PathPattern.COMPARATOR);

    public void process(Resource resource, final boolean subResourceMode) {
        if (!resource.isRootResource() && !subResourceMode) {
            return;
        }
        if (!resource.getResourceMethods().isEmpty()) {
            PathPattern closedResourcePathPattern = subResourceMode ? PathPattern.END_OF_PATH_PATTERN : PathPattern.asClosed((PathPattern)resource.getPathPattern());
            LinkedList sameResourcePathList = this.rootAcceptors.get(closedResourcePathPattern);
            if (sameResourcePathList == null) {
                sameResourcePathList = Lists.newLinkedList();
                this.rootAcceptors.put(closedResourcePathPattern, sameResourcePathList);
            }
            sameResourcePathList.addAll(Lists.transform(resource.getResourceMethods(), (Function)new Function<ResourceMethod, MethodAcceptorPair>(){

                public MethodAcceptorPair apply(ResourceMethod methodModel) {
                    return new MethodAcceptorPair(methodModel, RuntimeModelBuilder.this.createSingleMethodAcceptor(methodModel, subResourceMode));
                }
            }));
        }
        if (resource.getSubResourceMethods().size() + resource.getSubResourceLocators().size() > 0) {
            PathPattern openResourcePathPattern = subResourceMode ? PathPattern.OPEN_ROOT_PATH_PATTERN : resource.getPathPattern();
            TreeMap sameResourcePathMap = this.subResourceAcceptors.get(openResourcePathPattern);
            if (sameResourcePathMap == null) {
                sameResourcePathMap = Maps.newTreeMap((Comparator)PathPattern.COMPARATOR);
                this.subResourceAcceptors.put(openResourcePathPattern, sameResourcePathMap);
            }
            for (ResourceMethod methodModel : resource.getSubResourceMethods()) {
                this.updateSubResourceMethodMap(sameResourcePathMap, methodModel, subResourceMode);
            }
            for (ResourceMethod methodModel : resource.getSubResourceLocators()) {
                this.updateSubResourceMethodMap(sameResourcePathMap, methodModel, subResourceMode);
            }
        }
    }

    private void updateSubResourceMethodMap(TreeMap<PathPattern, List<MethodAcceptorPair>> subResourceMethodMap, ResourceMethod methodModel, boolean subResourceMode) {
        PathPattern openMethodPattern = new PathPattern(methodModel.getPath());
        LinkedList samePathMethodAcceptorPairs = subResourceMethodMap.get(openMethodPattern);
        if (samePathMethodAcceptorPairs == null) {
            samePathMethodAcceptorPairs = Lists.newLinkedList();
            subResourceMethodMap.put(openMethodPattern, samePathMethodAcceptorPairs);
        }
        samePathMethodAcceptorPairs.add(new MethodAcceptorPair(methodModel, this.createSingleMethodAcceptor(methodModel, subResourceMode)));
    }

    private Router createSingleMethodAcceptor(ResourceMethod resourceMethod, boolean subResourceMode) {
        Router methodAcceptor = null;
        switch (resourceMethod.getType()) {
            case RESOURCE_METHOD: 
            case SUB_RESOURCE_METHOD: {
                methodAcceptor = Routers.asTreeAcceptor(this.createInflector(resourceMethod));
                break;
            }
            case SUB_RESOURCE_LOCATOR: {
                methodAcceptor = new SubResourceLocatorRouter(this.locator, this, resourceMethod);
            }
        }
        if (subResourceMode) {
            return methodAcceptor;
        }
        return this.pushHandlerAcceptorBuilder.build(resourceMethod.getInvocable().getHandler(), methodAcceptor);
    }

    private Inflector<ContainerRequest, ContainerResponse> createInflector(ResourceMethod method) {
        return this.resourceMethodInvokerBuilder.build(method, this.nameBoundRequestFilters, this.nameBoundResponseFilters, this.globalReaderInterceptors, this.globalWriterInterceptors, this.nameBoundReaderInterceptors, this.nameBoundWriterInterceptors, this.dynamicBinders);
    }

    private Router createRootTreeAcceptor(RouterBinder.RouteToPathBuilder<PathPattern> lastRoutedBuilder, boolean subResourceMode) {
        Router routingRoot = lastRoutedBuilder != null ? lastRoutedBuilder.build() : Routers.acceptingTree(new Function<ContainerRequest, ContainerRequest>(){

            public ContainerRequest apply(ContainerRequest input) {
                return input;
            }
        }).build();
        if (subResourceMode) {
            return routingRoot;
        }
        return this.rootBuilder.root(routingRoot);
    }

    private RouterBinder.RouteToPathBuilder<PathPattern> routeMethodAcceptor(RouterBinder.RouteToPathBuilder<PathPattern> lastRoutedBuilder, PathPattern pathPattern, Router uriPushingAcceptor, Router methodAcceptor, boolean subResourceMode) {
        if (subResourceMode) {
            return this.routedBuilder(lastRoutedBuilder).route(pathPattern).to(methodAcceptor);
        }
        return this.routedBuilder(lastRoutedBuilder).route(pathPattern).to(uriPushingAcceptor).to(methodAcceptor);
    }

    public Router buildModel(boolean subResourceMode) {
        PushMatchedUriRouter uriPushingRouter = (PushMatchedUriRouter)this.locator.createAndInitialize(PushMatchedUriRouter.class);
        RouterBinder.RouteToPathBuilder<PathPattern> lastRoutedBuilder = null;
        if (!this.rootAcceptors.isEmpty()) {
            for (Map.Entry<PathPattern, List<MethodAcceptorPair>> entry : this.rootAcceptors.entrySet()) {
                PathPattern closedResourcePathPattern = entry.getKey();
                List<MethodAcceptorPair> methodAcceptorPairs = entry.getValue();
                lastRoutedBuilder = this.routeMethodAcceptor(lastRoutedBuilder, closedResourcePathPattern, uriPushingRouter, this.methodSelectingAcceptorBuilder.build(this.workers, methodAcceptorPairs), subResourceMode);
            }
            this.rootAcceptors.clear();
        }
        if (!this.subResourceAcceptors.isEmpty()) {
            for (Map.Entry<PathPattern, Object> entry : this.subResourceAcceptors.entrySet()) {
                RouterBinder.RouteToPathBuilder srRoutedBuilder = null;
                for (Map.Entry singlePathEntry : ((TreeMap)entry.getValue()).entrySet()) {
                    LinkedList subResourceMethods = Lists.newLinkedList();
                    MethodAcceptorPair locator = null;
                    for (MethodAcceptorPair methodAcceptorPair : (List)singlePathEntry.getValue()) {
                        if (methodAcceptorPair.model.getType() == ResourceMethod.JaxrsType.SUB_RESOURCE_METHOD) {
                            subResourceMethods.add(methodAcceptorPair);
                            continue;
                        }
                        locator = methodAcceptorPair;
                    }
                    if (!subResourceMethods.isEmpty()) {
                        PathPattern subResourceMethodPath = PathPattern.asClosed((PathPattern)((PathPattern)singlePathEntry.getKey()));
                        srRoutedBuilder = this.routedBuilder(srRoutedBuilder).route(subResourceMethodPath).to(uriPushingRouter).to(this.methodSelectingAcceptorBuilder.build(this.workers, subResourceMethods));
                    }
                    if (locator == null) continue;
                    srRoutedBuilder = this.routedBuilder(srRoutedBuilder).route((PathPattern)singlePathEntry.getKey()).to(uriPushingRouter).to(locator.router);
                }
                assert (srRoutedBuilder != null);
                lastRoutedBuilder = this.routeMethodAcceptor(lastRoutedBuilder, entry.getKey(), uriPushingRouter, srRoutedBuilder.build(), subResourceMode);
            }
            this.subResourceAcceptors.clear();
        }
        return this.createRootTreeAcceptor(lastRoutedBuilder, subResourceMode);
    }

    private RouterBinder.RouteBuilder<PathPattern> routedBuilder(RouterBinder.RouteToPathBuilder<PathPattern> lastRoutedBuilder) {
        return lastRoutedBuilder == null ? this.rootBuilder : lastRoutedBuilder;
    }

    public void setWorkers(MessageBodyWorkers workers) {
        this.workers = workers;
    }

    public void setGlobalInterceptors(Collection<ReaderInterceptor> readerInterceptors, Collection<WriterInterceptor> writerInterceptors) {
        this.globalReaderInterceptors = readerInterceptors;
        this.globalWriterInterceptors = writerInterceptors;
    }

    public void setBoundProviders(MultivaluedMap<Class<? extends Annotation>, ContainerRequestFilter> nameBoundRequestFilters, MultivaluedMap<Class<? extends Annotation>, ContainerResponseFilter> nameBoundResponseFilters, MultivaluedMap<Class<? extends Annotation>, ReaderInterceptor> nameBoundReaderInterceptors, MultivaluedMap<Class<? extends Annotation>, WriterInterceptor> nameBoundWriterInterceptors, List<DynamicBinder> dynamicBinders) {
        this.nameBoundRequestFilters = nameBoundRequestFilters;
        this.nameBoundResponseFilters = nameBoundResponseFilters;
        this.nameBoundReaderInterceptors = nameBoundReaderInterceptors;
        this.nameBoundWriterInterceptors = nameBoundWriterInterceptors;
        this.dynamicBinders = dynamicBinders;
    }
}

