/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.BindingBuilder;
import org.glassfish.jersey.internal.inject.Injections;

public class SingletonResourceBinder {
    private Set<Class<?>> registeredClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Object lock = new Object();
    @Inject
    private ServiceLocator locator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void bindResourceClassAsSingleton(Class<T> resourceClass) {
        if (this.registeredClasses.contains(resourceClass)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.registeredClasses.contains(resourceClass)) {
                return;
            }
            if (resourceClass.isAnnotationPresent(Singleton.class)) {
                DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
                Object instance = this.locator.createAndInitialize(resourceClass);
                Injections.addBinding((BindingBuilder)Injections.newBinder((Object)instance).to(resourceClass), (DynamicConfiguration)dc);
                dc.commit();
            }
            this.registeredClasses.add(resourceClass);
        }
    }

    public static class SingletonResourceBinderBinder
    extends AbstractBinder {
        protected void configure() {
            this.bindAsContract(SingletonResourceBinder.class).in(Singleton.class);
        }
    }
}

