/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.server.model.HandlerConstructor;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelVisitor;

public abstract class MethodHandler
implements ResourceModelComponent {
    public static MethodHandler create(Class<?> handlerClass) {
        return new ClassBasedMethodHandler(handlerClass);
    }

    public static MethodHandler create(Class<?> handlerClass, boolean disableParamDecoding) {
        return new ClassBasedMethodHandler(handlerClass, disableParamDecoding);
    }

    public static MethodHandler create(Object handlerInstance) {
        return new InstanceBasedMethodHandler(handlerInstance);
    }

    public static MethodHandler create(Object handlerInstance, Class<?> handlerClass) {
        return new InstanceBasedMethodHandler(handlerInstance, handlerClass);
    }

    public abstract Class<?> getHandlerClass();

    public List<HandlerConstructor> getConstructors() {
        return Collections.emptyList();
    }

    public abstract Object getInstance(ServiceLocator var1);

    public abstract boolean isClassBased();

    @Override
    public List<? extends ResourceModelComponent> getComponents() {
        return null;
    }

    @Override
    public void accept(ResourceModelVisitor visitor) {
        visitor.visitMethodHandler(this);
    }

    private static class InstanceBasedMethodHandler
    extends MethodHandler {
        private final Object handler;
        private final Class<?> handlerClass;

        public InstanceBasedMethodHandler(Object handler) {
            this.handler = handler;
            this.handlerClass = handler.getClass();
        }

        public InstanceBasedMethodHandler(Object handler, Class<?> handlerClass) {
            this.handler = handler;
            this.handlerClass = handlerClass;
        }

        @Override
        public Class<?> getHandlerClass() {
            return this.handlerClass;
        }

        @Override
        public Object getInstance(ServiceLocator locator) {
            locator.inject(this.handler);
            return this.handler;
        }

        @Override
        public boolean isClassBased() {
            return false;
        }
    }

    private static class ClassBasedMethodHandler
    extends MethodHandler {
        private final Class<?> handlerClass;
        private final List<HandlerConstructor> handlerConstructors;

        public ClassBasedMethodHandler(Class<?> handlerClass) {
            this(handlerClass, false);
        }

        public ClassBasedMethodHandler(Class<?> handlerClass, boolean disableParamDecoding) {
            this.handlerClass = handlerClass;
            LinkedList<HandlerConstructor> constructors = new LinkedList<HandlerConstructor>();
            for (Constructor<?> constructor : handlerClass.getConstructors()) {
                constructors.add(new HandlerConstructor(constructor, Parameter.create(handlerClass, handlerClass, constructor, disableParamDecoding)));
            }
            this.handlerConstructors = Collections.unmodifiableList(constructors);
        }

        @Override
        public Class<?> getHandlerClass() {
            return this.handlerClass;
        }

        @Override
        public List<HandlerConstructor> getConstructors() {
            return this.handlerConstructors;
        }

        @Override
        public Object getInstance(ServiceLocator locator) {
            return Injections.getOrCreate((ServiceLocator)locator, this.handlerClass);
        }

        @Override
        public boolean isClassBased() {
            return true;
        }

        @Override
        public List<? extends ResourceModelComponent> getComponents() {
            return this.handlerConstructors;
        }

        public String toString() {
            return "MethodHandler{handlerClass=" + this.handlerClass + ", handlerConstructors=" + this.handlerConstructors + '}';
        }
    }
}

