/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.filter;

import deprecated.javax.ws.rs.DynamicBinder;
import java.io.IOException;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.model.AnnotatedMethod;

public class RolesAllowedDynamicBinder
implements DynamicBinder<ContainerRequestFilter> {
    public ContainerRequestFilter getBoundProvider(ResourceInfo resourceInfo) {
        AnnotatedMethod am = new AnnotatedMethod(resourceInfo.getResourceMethod());
        if (am.isAnnotationPresent(DenyAll.class)) {
            return new RolesAllowedRequestFilter();
        }
        RolesAllowed ra = am.getAnnotation(RolesAllowed.class);
        if (ra != null) {
            return new RolesAllowedRequestFilter(ra.value());
        }
        if (am.isAnnotationPresent(PermitAll.class)) {
            return null;
        }
        ra = resourceInfo.getResourceClass().getAnnotation(RolesAllowed.class);
        if (ra != null) {
            return new RolesAllowedRequestFilter(ra.value());
        }
        return null;
    }

    @BindingPriority(value=3000)
    private static class RolesAllowedRequestFilter
    implements ContainerRequestFilter {
        private final boolean denyAll;
        private final String[] rolesAllowed;

        RolesAllowedRequestFilter() {
            this.denyAll = true;
            this.rolesAllowed = null;
        }

        RolesAllowedRequestFilter(String[] rolesAllowed) {
            this.denyAll = false;
            this.rolesAllowed = rolesAllowed != null ? rolesAllowed : new String[]{};
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            if (!this.denyAll) {
                for (String role : this.rolesAllowed) {
                    if (!requestContext.getSecurityContext().isUserInRole(role)) continue;
                    return;
                }
            }
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }
}

