/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Function;
import deprecated.javax.ws.rs.DynamicBinder;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.NameBinding;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.Config;
import org.glassfish.jersey.internal.ExtractorException;
import org.glassfish.jersey.internal.MappableException;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.BindingBuilder;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.ProviderBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.InflectorNotFoundException;
import org.glassfish.jersey.process.internal.PriorityComparator;
import org.glassfish.jersey.process.internal.ProcessingCallback;
import org.glassfish.jersey.process.internal.ProcessingContext;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ChunkedResponse;
import org.glassfish.jersey.server.CloseableService;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerFilteringStage;
import org.glassfish.jersey.server.ContainerMessageBodyWorkersInitializer;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ContainerResponseWriterCallback;
import org.glassfish.jersey.server.ProviderBag;
import org.glassfish.jersey.server.ReferencesInitializer;
import org.glassfish.jersey.server.ResourceBag;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerBinder;
import org.glassfish.jersey.server.TimingOutProcessingCallback;
import org.glassfish.jersey.server.internal.JerseyResourceContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.routing.RoutedInflectorExtractorStage;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingStage;
import org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import org.glassfish.jersey.server.model.BasicValidator;
import org.glassfish.jersey.server.model.ModelValidationException;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.model.ResourceModelValidator;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.wadl.WadlApplicationContext;
import org.glassfish.jersey.server.wadl.internal.WadlApplicationContextImpl;
import org.glassfish.jersey.server.wadl.internal.WadlResource;
import org.glassfish.jersey.spi.ExceptionMappers;

public final class ApplicationHandler {
    private static final Logger LOGGER = Logger.getLogger(ApplicationHandler.class.getName());
    private static final SecurityContext DEFAULT_SECURITY_CONTEXT = new SecurityContext(){

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    };
    @Inject
    private Factory<CloseableService> closeableServiceFactory;
    private ServiceLocator locator;
    private RequestInvoker<ContainerRequest, ContainerResponse> invoker;
    private final ResourceConfig configuration;

    public ApplicationHandler() {
        this.initServiceLocator();
        this.configuration = new ResourceConfig();
        this.initialize();
    }

    public ApplicationHandler(Class<? extends Application> jaxrsApplicationClass) {
        this.initServiceLocator();
        this.configuration = ResourceConfig.class.isAssignableFrom(jaxrsApplicationClass) ? (ResourceConfig)this.createApplication(jaxrsApplicationClass) : ResourceConfig.forApplicationClass(jaxrsApplicationClass);
        this.initialize();
    }

    public ApplicationHandler(Application application) {
        this.initServiceLocator();
        this.configuration = ResourceConfig.forApplication(application);
        this.initialize();
    }

    private void initServiceLocator() {
        this.locator = Injections.createLocator((Binder[])new Binder[]{new ServerBinder(), new ApplicationBinder()});
    }

    private void initialize() {
        Resource resource;
        boolean isResource;
        this.registerAdditionalBinders(this.configuration.getCustomBinders());
        Class<? extends Application> applicationClass = this.configuration.getApplicationClass();
        if (applicationClass != null) {
            Application application = this.createApplication(applicationClass);
            if (application instanceof ResourceConfig) {
                this.registerAdditionalBinders(((ResourceConfig)application).getCustomBinders());
            }
            this.configuration.setApplication(application);
        }
        this.configuration.lock();
        ProviderBag.Builder providerBagBuilder = new ProviderBag.Builder();
        ResourceBag.Builder resourceBagBuilder = new ResourceBag.Builder();
        LinkedList<ResourceModelIssue> resourceModelIssues = new LinkedList<ResourceModelIssue>();
        HashSet classes = new HashSet(this.configuration.getClasses());
        boolean wadlDisabled = this.configuration.isProperty("jersey.config.server.wadl.disableWadl");
        if (!wadlDisabled) {
            classes.add(WadlResource.class);
        }
        for (Class clazz : classes) {
            isResource = false;
            try {
                resource = Resource.from(clazz, resourceModelIssues);
                boolean bl = isResource = resource != null;
                if (isResource) {
                    resourceBagBuilder.registerResource(clazz, resource);
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning(ex.getMessage());
            }
            providerBagBuilder.register(clazz, isResource);
        }
        for (Object object : this.configuration.getSingletons()) {
            isResource = false;
            try {
                resource = Resource.from(object, resourceModelIssues);
                boolean bl = isResource = resource != null;
                if (isResource) {
                    resourceBagBuilder.registerResource(object, resource);
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning(ex.getMessage());
            }
            providerBagBuilder.register(object, isResource);
        }
        ProviderBag providerBag = providerBagBuilder.build();
        for (Resource programmaticResource : this.configuration.getResources()) {
            resourceBagBuilder.registerProgrammaticResource(programmaticResource);
        }
        ResourceBag resourceBag = resourceBagBuilder.build();
        HashSet<ComponentProvider> componentProviders = new HashSet<ComponentProvider>();
        for (ComponentProvider provider : ServiceFinder.find(ComponentProvider.class)) {
            provider.initialize(this.locator);
            componentProviders.add(provider);
        }
        this.registerProvidersAndResources(componentProviders, providerBag, resourceBag);
        for (ComponentProvider componentProvider : componentProviders) {
            componentProvider.done();
        }
        Collection applicationNameBindings = ReflectionHelper.getAnnotationTypes(this.configuration.getApplication().getClass(), NameBinding.class);
        List responseFilters = Providers.getAllProviders((ServiceLocator)this.locator, ContainerResponseFilter.class);
        MultivaluedMap nameBoundResponseFilters = ApplicationHandler.filterNameBound(responseFilters, null, providerBag, applicationNameBindings);
        List requestFilters = Providers.getAllProviders((ServiceLocator)this.locator, ContainerRequestFilter.class, (Comparator)new PriorityComparator(PriorityComparator.Order.ASCENDING));
        ArrayList<ContainerRequestFilter> preMatchFilters = new ArrayList<ContainerRequestFilter>();
        MultivaluedMap nameBoundRequestFilters = ApplicationHandler.filterNameBound(requestFilters, preMatchFilters, providerBag, applicationNameBindings);
        List readerInterceptors = this.locator.getAllServices(ReaderInterceptor.class, new Annotation[0]);
        MultivaluedMap nameBoundReaderInterceptors = ApplicationHandler.filterNameBound(readerInterceptors, null, providerBag, applicationNameBindings);
        List writerInterceptors = this.locator.getAllServices(WriterInterceptor.class, new Annotation[0]);
        MultivaluedMap nameBoundWriterInterceptors = ApplicationHandler.filterNameBound(writerInterceptors, null, providerBag, applicationNameBindings);
        List dynamicBinders = Providers.getAllProviders((ServiceLocator)this.locator, DynamicBinder.class);
        this.validate(resourceBag.models, resourceModelIssues, (MessageBodyWorkers)this.locator.getService(MessageBodyWorkers.class, new Annotation[0]));
        DynamicConfiguration dynamicConfiguration = Injections.getConfiguration((ServiceLocator)this.locator);
        Injections.addBinding((BindingBuilder)Injections.newBinder((Object)new WadlApplicationContextImpl(resourceBag.models, this.configuration)).to(WadlApplicationContext.class), (DynamicConfiguration)dynamicConfiguration);
        dynamicConfiguration.commit();
        RuntimeModelBuilder runtimeModelBuilder = (RuntimeModelBuilder)this.locator.getService(RuntimeModelBuilder.class, new Annotation[0]);
        runtimeModelBuilder.setGlobalInterceptors(readerInterceptors, writerInterceptors);
        runtimeModelBuilder.setBoundProviders(nameBoundRequestFilters, nameBoundResponseFilters, nameBoundReaderInterceptors, nameBoundWriterInterceptors, dynamicBinders);
        for (Resource resource2 : resourceBag.models) {
            runtimeModelBuilder.process(resource2, false);
        }
        Router resourceRoutingRoot = runtimeModelBuilder.buildModel(false);
        ContainerFilteringStage preMatchRequestFilteringStage = ((ContainerFilteringStage.Builder)this.locator.createAndInitialize(ContainerFilteringStage.Builder.class)).build(preMatchFilters, responseFilters);
        RoutingStage routingStage = ((RoutingStage.Builder)this.locator.createAndInitialize(RoutingStage.Builder.class)).build(resourceRoutingRoot);
        ContainerFilteringStage resourceFilteringStage = ((ContainerFilteringStage.Builder)this.locator.createAndInitialize(ContainerFilteringStage.Builder.class)).build(requestFilters, null);
        RoutedInflectorExtractorStage routedInflectorExtractorStage = (RoutedInflectorExtractorStage)this.locator.createAndInitialize(RoutedInflectorExtractorStage.class);
        Stage rootStage = Stages.chain((Function)((Function)this.locator.createAndInitialize(ReferencesInitializer.class))).to((Function)this.locator.createAndInitialize(ContainerMessageBodyWorkersInitializer.class)).to((ChainableStage)preMatchRequestFilteringStage).to((ChainableStage)routingStage).to((ChainableStage)resourceFilteringStage).build((Stage)routedInflectorExtractorStage);
        for (Object instance : providerBag.instances) {
            this.locator.inject(instance);
        }
        for (Object instance : resourceBag.instances) {
            this.locator.inject(instance);
        }
        this.invoker = ((ServerBinder.RequestInvokerBuilder)this.locator.createAndInitialize(ServerBinder.RequestInvokerBuilder.class)).build((Stage<ContainerRequest>)rootStage);
        this.locator.inject((Object)this);
    }

    private static <T> MultivaluedMap<Class<? extends Annotation>, T> filterNameBound(Collection<T> all, Collection<ContainerRequestFilter> preMatching, ProviderBag providerBag, Collection<Class<? extends Annotation>> applicationNameBindings) {
        MultivaluedHashMap result = new MultivaluedHashMap();
        Iterator<T> it = all.iterator();
        while (it.hasNext()) {
            boolean nameBound;
            ContractProvider model;
            T provider = it.next();
            Class<?> providerClass = provider.getClass();
            if (preMatching != null && providerClass.getAnnotation(PreMatching.class) != null) {
                it.remove();
                preMatching.add((ContainerRequestFilter)provider);
            }
            if ((model = providerBag.models.get(providerClass)) == null) {
                model = ContractProvider.from(providerClass);
            }
            if ((nameBound = model.isNameBound()) && !applicationNameBindings.isEmpty()) {
                for (Class binding : model.getNameBindings()) {
                    if (!applicationNameBindings.contains(binding)) continue;
                    nameBound = false;
                    break;
                }
            }
            if (!nameBound) continue;
            it.remove();
            for (Class binding : model.getNameBindings()) {
                result.add((Object)binding, provider);
            }
        }
        return result;
    }

    private void registerProvidersAndResources(Set<ComponentProvider> componentProviders, ProviderBag providerBag, ResourceBag resourceBag) {
        ContractProvider model;
        ContractProvider providerModel;
        JerseyResourceContext resourceContext = (JerseyResourceContext)this.locator.getService(JerseyResourceContext.class, new Annotation[0]);
        DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
        for (Class<?> clazz : resourceBag.classes) {
            if (this.bindWithComponentProvider(clazz, providerModel = providerBag.models.get(clazz), componentProviders)) continue;
            if (!Resource.isAcceptable(clazz)) {
                LOGGER.warning(LocalizationMessages.NON_INSTANTIABLE_CLASS(clazz));
                continue;
            }
            resourceContext.unsafeBindResource(clazz, providerModel, dc);
        }
        for (Object object : resourceBag.instances) {
            providerModel = providerBag.models.get(object.getClass());
            resourceContext.unsafeBindResource(object, providerModel, dc);
        }
        for (Class clazz : providerBag.classes) {
            model = providerBag.models.get(clazz);
            ProviderBinder.bindProvider((Class)clazz, (ContractProvider)model, (DynamicConfiguration)dc);
        }
        for (Object object : providerBag.instances) {
            model = providerBag.models.get(object.getClass());
            ProviderBinder.bindProvider((Object)object, (ContractProvider)model, (DynamicConfiguration)dc);
        }
        dc.commit();
    }

    private boolean bindWithComponentProvider(Class<?> component, ContractProvider providerModel, Collection<ComponentProvider> componentProviders) {
        Set contracts = providerModel == null ? Collections.emptySet() : providerModel.getContracts();
        for (ComponentProvider provider : componentProviders) {
            if (!provider.bind(component, contracts)) continue;
            return true;
        }
        return false;
    }

    private Application createApplication(Class<? extends Application> applicationClass) {
        if (applicationClass == ResourceConfig.class) {
            return new ResourceConfig();
        }
        if (applicationClass == Application.class) {
            return new Application();
        }
        return (Application)this.locator.createAndInitialize(applicationClass);
    }

    public void registerAdditionalBinders(Set<Binder> binders) {
        DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
        for (Binder binder : binders) {
            binder.bind(dc);
        }
        dc.commit();
    }

    private void validate(List<Resource> resources, List<ResourceModelIssue> modelIssues, MessageBodyWorkers workers) {
        BasicValidator validator = new BasicValidator(modelIssues, workers);
        for (Resource r : resources) {
            validator.validate(r);
        }
        this.processIssues(validator);
    }

    private void processIssues(ResourceModelValidator validator) {
        List<ResourceModelIssue> issueList = validator.getIssueList();
        if (!issueList.isEmpty()) {
            String allIssueMessages = this.allIssueLogMessages(validator.getIssueList());
            if (validator.fatalIssuesFound()) {
                LOGGER.severe(LocalizationMessages.ERRORS_AND_WARNINGS_DETECTED_WITH_RESOURCE_CLASSES(allIssueMessages));
            } else {
                LOGGER.warning(LocalizationMessages.WARNINGS_DETECTED_WITH_RESOURCE_CLASSES(allIssueMessages));
            }
        }
        if (validator.fatalIssuesFound()) {
            throw new ModelValidationException(issueList);
        }
    }

    private String allIssueLogMessages(List<ResourceModelIssue> issueList) {
        StringBuilder errors = new StringBuilder("\n");
        StringBuilder warnings = new StringBuilder();
        for (ResourceModelIssue issue : issueList) {
            if (issue.isFatal()) {
                errors.append(LocalizationMessages.ERROR_MSG(issue.getMessage())).append('\n');
                continue;
            }
            warnings.append(LocalizationMessages.WARNING_MSG(issue.getMessage())).append('\n');
        }
        return errors.append((CharSequence)warnings).toString();
    }

    public Future<ContainerResponse> apply(ContainerRequest requestContext) {
        return this.apply(requestContext, new OutputStream(){

            @Override
            public void write(int i) throws IOException {
            }
        });
    }

    public Future<ContainerResponse> apply(final ContainerRequest requestContext, final OutputStream outputStream) {
        requestContext.setSecurityContext(DEFAULT_SECURITY_CONTEXT);
        requestContext.setWriter(new ContainerResponseWriter(){

            @Override
            public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse responseContext) throws ContainerException {
                if (contentLength >= 0L) {
                    responseContext.getHeaders().putSingle((Object)"Content-Length", (Object)Long.toString(contentLength));
                }
                return outputStream;
            }

            @Override
            public void suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) throws IllegalStateException {
            }

            @Override
            public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            }

            @Override
            public void cancel() {
            }

            @Override
            public void commit() {
            }
        });
        TimingOutProcessingCallback callback = new TimingOutProcessingCallback(){
            private ContainerResponse responseContext;

            @Override
            protected ContainerResponse handleResponse(ContainerResponse responseContext) {
                this.responseContext = ApplicationHandler.this.writeResponse(requestContext, responseContext);
                if ("HEAD".equals(requestContext.getMethod())) {
                    ApplicationHandler.this.stripEntity(responseContext);
                }
                return responseContext;
            }

            @Override
            protected ContainerResponse handleFailure(Throwable exception) {
                this.responseContext = ApplicationHandler.this.writeResponse(requestContext, ApplicationHandler.handleFailure(exception, requestContext, this.responseContext, ApplicationHandler.this.locator));
                return this.responseContext;
            }

            @Override
            protected ContainerResponse handleTimeout(ProcessingContext context) {
                this.responseContext = ApplicationHandler.this.writeResponse(requestContext, ApplicationHandler.prepareTimeoutResponse(context, requestContext));
                return this.responseContext;
            }

            @Override
            protected void release() {
                ApplicationHandler.this.releaseRequestProcessing(this.responseContext);
            }
        };
        this.invoker.apply((Object)requestContext, (ProcessingCallback)callback);
        return callback;
    }

    private ContainerResponse stripEntity(ContainerResponse responseContext) {
        if (responseContext.hasEntity()) {
            responseContext.setEntity(null);
        }
        return responseContext;
    }

    public void handle(ContainerRequest requestContext) {
        this.checkContainerRequestContext(requestContext);
        ContainerResponseWriterCallback callback = new ContainerResponseWriterCallback(requestContext){
            private ContainerResponse responseContext;

            @Override
            protected void writeResponse(ContainerResponse response) {
                this.responseContext = ApplicationHandler.this.writeResponse(this.requestContext, response);
            }

            @Override
            protected void writeResponse(Throwable exception) {
                this.responseContext = ApplicationHandler.this.writeResponse(this.requestContext, ApplicationHandler.handleFailure(exception, this.requestContext, this.responseContext, ApplicationHandler.this.locator));
            }

            @Override
            protected void writeTimeoutResponse(ProcessingContext context) {
                this.responseContext = ApplicationHandler.this.writeResponse(this.requestContext, ApplicationHandler.prepareTimeoutResponse(context, this.requestContext));
            }

            @Override
            protected void release() {
                ApplicationHandler.this.releaseRequestProcessing(this.responseContext);
            }
        };
        this.invoker.apply((Object)requestContext, (ProcessingCallback)callback);
        callback.suspendWriterIfRunning();
    }

    private void releaseRequestProcessing(ContainerResponse responseContext) {
        ((CloseableService)this.closeableServiceFactory.provide()).close();
        if (responseContext != null && !responseContext.isChunked()) {
            responseContext.close();
        }
    }

    private void checkContainerRequestContext(ContainerRequest requestContext) {
        if (requestContext.getSecurityContext() == null) {
            throw new IllegalArgumentException("SecurityContext from ContainerRequestContext must not be null.");
        }
        if (requestContext.getRequest() == null) {
            throw new IllegalArgumentException("Request from ContainerRequestContext must not be null.");
        }
        if (requestContext.getResponseWriter() == null) {
            throw new IllegalArgumentException("ResponseWriter from ContainerRequestContext must not be null.");
        }
    }

    private static ContainerResponse prepareTimeoutResponse(ProcessingContext context, ContainerRequest requestContext) {
        Response response = context.getResponse();
        if (response == null) {
            response = Response.serverError().entity((Object)"Request processing has timed out.").type("text/plain").build();
        }
        return new ContainerResponse(requestContext, response);
    }

    private static ContainerResponse handleFailure(Throwable failure, ContainerRequest requestContext, ContainerResponse containerResponse, ServiceLocator locator) {
        if (failure instanceof MappableException) {
            failure = failure.getCause();
        }
        Response.Status statusCode = Response.Status.INTERNAL_SERVER_ERROR;
        String message = failure.getMessage();
        if (containerResponse != null && containerResponse.isMappedFromException()) {
            return new ContainerResponse(requestContext, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
        ExceptionMappers mappers = (ExceptionMappers)locator.getService(ExceptionMappers.class, new Annotation[0]);
        ExceptionMapper mapper = mappers.find(failure.getClass());
        if (mapper != null) {
            try {
                return new ContainerResponse(requestContext, mapper.toResponse(failure));
            }
            catch (Exception e) {
                return new ContainerResponse(requestContext, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
            }
        }
        if (failure instanceof ProcessingException) {
            if (failure instanceof HeaderValueException) {
                statusCode = Response.Status.BAD_REQUEST;
            } else if (failure instanceof InflectorNotFoundException) {
                statusCode = Response.Status.NOT_FOUND;
                message = "Requested resource not found.";
            } else if (failure instanceof ExtractorException) {
                statusCode = Response.Status.BAD_REQUEST;
            }
        } else if (failure instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)failure;
            return new ContainerResponse(requestContext, wae.getResponse());
        }
        if (statusCode == Response.Status.INTERNAL_SERVER_ERROR) {
            LOGGER.log(Level.SEVERE, message, failure);
        } else {
            LOGGER.log(Level.FINE, message, failure);
        }
        return new ContainerResponse(requestContext, Response.status((Response.StatusType)statusCode).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerResponse writeResponse(ContainerRequest requestContext, final ContainerResponse responseContext) {
        block17: {
            final ContainerResponseWriter writer = requestContext.getResponseWriter();
            final MessageBodySizeCallback messageBodySizeCallback = new MessageBodySizeCallback();
            if (!responseContext.hasEntity()) {
                writer.writeResponseStatusAndHeaders(0L, responseContext);
                return responseContext;
            }
            Object entity = responseContext.getEntity();
            boolean skipFinally = false;
            try {
                responseContext.setStreamProvider(new OutboundMessageContext.StreamProvider(){
                    private OutputStream output;

                    public void commit() throws IOException {
                        long size = responseContext.getHeaders().getFirst((Object)"Content-Encoding") != null ? -1L : messageBodySizeCallback.getSize();
                        this.output = writer.writeResponseStatusAndHeaders(size, responseContext);
                    }

                    public OutputStream getOutputStream() throws IOException {
                        return this.output;
                    }
                });
                responseContext.setEntityStream(requestContext.getWorkers().writeTo(entity, entity.getClass(), responseContext.getEntityType(), responseContext.getEntityAnnotations(), responseContext.getMediaType(), responseContext.getHeaders(), requestContext.getPropertiesDelegate(), responseContext.getEntityStream(), (MessageBodyWorkers.MessageBodySizeCallback)messageBodySizeCallback, true, !requestContext.getMethod().equals("HEAD")));
            }
            catch (Exception ex) {
                if (responseContext.isCommitted()) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_WRITING_RESPONSE_ENTITY(), ex);
                    break block17;
                }
                skipFinally = true;
                ContainerResponse containerResponse = this.writeResponse(requestContext, ApplicationHandler.handleFailure(ex, requestContext, responseContext, this.locator));
                return containerResponse;
            }
            finally {
                if (!skipFinally) {
                    responseContext.commitStream();
                    if (responseContext.isChunked()) {
                        try {
                            ((ChunkedResponse)entity).setContext(requestContext, responseContext);
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_WRITING_RESPONSE_ENTITY_CHUNK(), ex);
                        }
                        writer.suspend(0L, TimeUnit.SECONDS, null);
                    }
                }
            }
        }
        return responseContext;
    }

    public ServiceLocator getServiceLocator() {
        return this.locator;
    }

    public ResourceConfig getConfiguration() {
        return this.configuration;
    }

    private class MessageBodySizeCallback
    implements MessageBodyWorkers.MessageBodySizeCallback {
        private long size = -1L;

        private MessageBodySizeCallback() {
        }

        public void onRequestEntitySize(long size) throws IOException {
            this.size = size;
        }

        public long getSize() {
            return this.size;
        }
    }

    private class ApplicationBinder
    extends AbstractBinder {
        private ApplicationBinder() {
        }

        protected void configure() {
            this.bindFactory(new ResourceConfigProvider()).to(ResourceConfig.class).to(Config.class).in(Singleton.class);
            this.bindFactory(new JaxrsApplicationProvider()).to(Application.class).in(Singleton.class);
            this.bind(ApplicationHandler.this).to(ApplicationHandler.class);
        }

        private class ResourceConfigProvider
        implements Factory<ResourceConfig> {
            private ResourceConfigProvider() {
            }

            public ResourceConfig provide() {
                return ApplicationHandler.this.configuration;
            }

            public void dispose(ResourceConfig instance) {
            }
        }

        private class JaxrsApplicationProvider
        implements Factory<Application> {
            private JaxrsApplicationProvider() {
            }

            public Application provide() {
                return ApplicationHandler.this.configuration.getApplication();
            }

            public void dispose(Application instance) {
            }
        }
    }
}

