/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.glassfish.jersey.model.ContractProvider;

final class ProviderBag {
    final Set<Class<?>> classes;
    final Set<Object> instances;
    final Map<Class<?>, ContractProvider> models;

    private ProviderBag(Set<Class<?>> classes, Set<Object> instances, Map<Class<?>, ContractProvider> models) {
        this.classes = classes;
        this.instances = instances;
        this.models = models;
    }

    static final class Builder {
        private final Set<Class<?>> classes = Sets.newIdentityHashSet();
        private final Set<Object> instances = Sets.newIdentityHashSet();
        private final Map<Class<?>, ContractProvider> models = new IdentityHashMap();

        Builder() {
        }

        boolean register(Class<?> providerClass, boolean isResource) {
            if (!this.models.containsKey(providerClass)) {
                ContractProvider model = ContractProvider.from(providerClass);
                if (model == null) {
                    return false;
                }
                this.models.put(providerClass, model);
            }
            return isResource || this.classes.add(providerClass);
        }

        boolean register(Object provider, boolean isResource) {
            Class<?> providerClass = provider.getClass();
            if (!this.models.containsKey(providerClass)) {
                ContractProvider model = ContractProvider.from((Object)provider);
                if (model == null) {
                    return false;
                }
                this.models.put(providerClass, model);
            }
            return isResource || this.instances.add(provider);
        }

        ProviderBag build() {
            return new ProviderBag(this.classes, this.instances, this.models);
        }
    }
}

