/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.JaxrsProviders;
import org.glassfish.jersey.internal.ServiceFinderBinder;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.message.internal.MessagingBinders;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AsyncInflectorAdapter;
import org.glassfish.jersey.process.internal.DefaultRespondingContext;
import org.glassfish.jersey.process.internal.ExecutorsFactory;
import org.glassfish.jersey.process.internal.ProcessingBinder;
import org.glassfish.jersey.process.internal.ProcessingCallback;
import org.glassfish.jersey.process.internal.ProcessingContext;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.server.ChunkedResponseWriter;
import org.glassfish.jersey.server.ContainerFilteringStage;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ReferencesInitializer;
import org.glassfish.jersey.server.SecurityContextBinder;
import org.glassfish.jersey.server.internal.JerseyResourceContext;
import org.glassfish.jersey.server.internal.JsonWithPaddingInterceptor;
import org.glassfish.jersey.server.internal.ServerExecutorsFactory;
import org.glassfish.jersey.server.internal.inject.CloseableServiceBinder;
import org.glassfish.jersey.server.internal.inject.ParameterInjectionBinder;
import org.glassfish.jersey.server.internal.routing.RouterBinder;
import org.glassfish.jersey.server.model.ResourceModelBinder;
import org.glassfish.jersey.server.spi.ContainerProvider;
import org.glassfish.jersey.spi.ExceptionMappers;

public class ServerBinder
extends AbstractBinder {
    protected void configure() {
        this.install(new Binder[]{new RequestScope.Binder(), new ProcessingBinder(), new ContextInjectionResolver.Binder(), new MessagingBinders.MessageBodyProviders(), new MessageBodyFactory.Binder(), new ExceptionMapperFactory.Binder(), new ContextResolverFactory.Binder(), new JaxrsProviders.Binder(), new ContainerFilteringStage.Binder(), new SecurityContextBinder(), new ParameterInjectionBinder(), new ResourceModelBinder(), new RouterBinder(), new ServiceFinderBinder(ContainerProvider.class), new CloseableServiceBinder(), new JerseyResourceContext.Binder(), new ServerExecutorsFactory.ServerExecutorBinder()});
        this.bindFactory(RequestReferencingFactory.class).to(Request.class).in(PerLookup.class);
        this.bindFactory(ReferencingFactory.referenceFactory()).to((TypeLiteral)new TypeLiteral<Ref<Request>>(){}).in(RequestScoped.class);
        this.bindFactory(HttpHeadersFactory.class, Singleton.class).to(HttpHeaders.class).in(PerLookup.class);
        this.bindFactory(RequestContextInjectionFactory.class).to(ContainerRequest.class).in(RequestScoped.class);
        this.bindFactory(RequestContextInjectionFactory.class).to(ContainerRequestContext.class).in(RequestScoped.class);
        this.bindFactory(ReferencingFactory.referenceFactory()).to((TypeLiteral)new TypeLiteral<Ref<ContainerRequest>>(){}).in(RequestScoped.class);
        this.bind(DefaultRespondingContext.class).to((TypeLiteral)new TypeLiteral<ResponseProcessor.RespondingContext<ContainerResponse>>(){}).in(RequestScoped.class);
        this.bind(ResponseProcessorBuilder.class).to((TypeLiteral)new TypeLiteral<ResponseProcessor.Builder<ContainerResponse>>(){}).in(Singleton.class);
        this.bind(ChunkedResponseWriter.class).to(MessageBodyWriter.class).in(Singleton.class);
        this.bind(JsonWithPaddingInterceptor.class).to(WriterInterceptor.class).in(Singleton.class);
        this.bindAsContract(RequestInvokerBuilder.class);
        this.bindAsContract(ReferencesInitializer.class);
    }

    static class ResponseProcessorBuilder
    implements ResponseProcessor.Builder<ContainerResponse> {
        @Inject
        private RequestScope requestScope;
        @Inject
        private Provider<ResponseProcessor.RespondingContext<ContainerResponse>> respondingCtxProvider;
        @Inject
        private Provider<ExceptionMappers> exceptionMappersProvider;
        @Inject
        private Provider<ContainerRequest> requestContextFactory;

        public ResponseProcessor<ContainerResponse> build(Future<ContainerResponse> inflectedResponse, SettableFuture<ContainerResponse> processedResponse, ProcessingCallback<ContainerResponse> callback, RequestScope.Instance scopeInstance) {
            return new ResponseProcessor<ContainerResponse>(callback, inflectedResponse, processedResponse, this.respondingCtxProvider, scopeInstance, this.requestScope, this.exceptionMappersProvider){

                protected ContainerResponse convertResponse(Response exceptionResponse) {
                    if (exceptionResponse == null) {
                        return null;
                    }
                    ContainerResponse containerResponse = new ContainerResponse((ContainerRequest)((Object)ResponseProcessorBuilder.this.requestContextFactory.get()), exceptionResponse);
                    containerResponse.setMappedFromException(true);
                    return containerResponse;
                }
            };
        }
    }

    static final class RequestInvokerBuilder {
        @Inject
        private RequestScope requestScope;
        @Inject
        private ResponseProcessor.Builder<ContainerResponse> responseProcessorBuilder;
        @Inject
        private Provider<Ref<ProcessingContext>> invocationContextReferenceFactory;
        @Inject
        private ExecutorsFactory<ContainerRequest> executorsFactory;

        RequestInvokerBuilder() {
        }

        public RequestInvoker<ContainerRequest, ContainerResponse> build(Stage<ContainerRequest> rootStage) {
            return new RequestInvoker(rootStage, this.requestScope, (AsyncInflectorAdapter.Builder)new AsyncInflectorAdapter.Builder<ContainerRequest, ContainerResponse>(){

                public AsyncInflectorAdapter<ContainerRequest, ContainerResponse> create(Inflector<ContainerRequest, ContainerResponse> wrapped, ProcessingCallback<ContainerResponse> callback) {
                    return new AsyncInflectorAdapter<ContainerRequest, ContainerResponse>(wrapped, callback){

                        protected ContainerResponse convertResponse(ContainerRequest requestContext, Response response) {
                            return new ContainerResponse(requestContext, response);
                        }
                    };
                }
            }, this.responseProcessorBuilder, this.invocationContextReferenceFactory, this.executorsFactory);
        }
    }

    private static class RequestContextInjectionFactory
    extends ReferencingFactory<ContainerRequest> {
        @Inject
        public RequestContextInjectionFactory(Provider<Ref<ContainerRequest>> referenceFactory) {
            super(referenceFactory);
        }

        @RequestScoped
        public ContainerRequest provide() {
            return (ContainerRequest)((Object)super.provide());
        }
    }

    private static class HttpHeadersFactory
    implements Factory<HttpHeaders> {
        private final Provider<ContainerRequest> containerRequestContextProvider;

        @Inject
        public HttpHeadersFactory(Provider<ContainerRequest> containerRequestContextProvider) {
            this.containerRequestContextProvider = containerRequestContextProvider;
        }

        public HttpHeaders provide() {
            return (HttpHeaders)this.containerRequestContextProvider.get();
        }

        public void dispose(HttpHeaders httpHeaders) {
        }
    }

    private static class RequestReferencingFactory
    extends ReferencingFactory<Request> {
        @Inject
        public RequestReferencingFactory(Provider<Ref<Request>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

