/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.util.concurrent.AbstractFuture;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.process.internal.ProcessingCallback;
import org.glassfish.jersey.process.internal.ProcessingContext;
import org.glassfish.jersey.server.ContainerResponse;

abstract class TimingOutProcessingCallback
extends AbstractFuture<ContainerResponse>
implements ProcessingCallback<ContainerResponse> {
    private static final Logger logger = Logger.getLogger(TimingOutProcessingCallback.class.getName());
    private static final Timer TIMER = new Timer("Jersey application request timer");
    private final Object suspendLock = new Object();
    private final AtomicBoolean done = new AtomicBoolean(false);
    private ProcessingContext processingCtx = null;
    private TimerTask timeoutTask = null;

    protected TimingOutProcessingCallback() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void result(ContainerResponse response) {
        if (this.done.compareAndSet(false, true)) {
            try {
                this.set(this.handleResponse(response));
            }
            catch (Throwable t) {
                this.setException(t);
            }
            finally {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failure(Throwable failure) {
        if (this.done.compareAndSet(false, true)) {
            try {
                this.set(this.handleFailure(failure));
            }
            catch (Throwable t) {
                this.setException(t);
            }
            finally {
                this.release();
            }
        }
    }

    protected abstract ContainerResponse handleFailure(Throwable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelled() {
        if (this.done.compareAndSet(false, true)) {
            try {
                this.cancel(true);
            }
            finally {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspended(long time, TimeUnit unit, ProcessingContext context) {
        TimerTask task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (TimingOutProcessingCallback.this.done.compareAndSet(false, true)) {
                    try {
                        TimingOutProcessingCallback.this.set(TimingOutProcessingCallback.this.handleTimeout(TimingOutProcessingCallback.this.processingCtx));
                    }
                    catch (Throwable t) {
                        TimingOutProcessingCallback.this.setException(t);
                    }
                    finally {
                        TimingOutProcessingCallback.this.release();
                    }
                }
            }
        };
        Object object = this.suspendLock;
        synchronized (object) {
            if (this.processingCtx != null) {
                throw new IllegalStateException("Already suspended");
            }
            this.processingCtx = context;
            if (time <= 0L) {
                return;
            }
            this.timeoutTask = task;
        }
        try {
            TIMER.schedule(task, unit.toMillis(time));
        }
        catch (IllegalStateException ex) {
            logger.log(Level.WARNING, "Error while scheduling a timeout task.", ex);
        }
    }

    protected abstract ContainerResponse handleTimeout(ProcessingContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendTimeoutChanged(long time, TimeUnit unit) {
        if (!this.done.get()) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (TimingOutProcessingCallback.this.done.compareAndSet(false, true)) {
                        try {
                            TimingOutProcessingCallback.this.set(TimingOutProcessingCallback.this.handleTimeout(TimingOutProcessingCallback.this.processingCtx));
                        }
                        catch (Throwable t) {
                            TimingOutProcessingCallback.this.setException(t);
                        }
                    }
                }
            };
            Object object = this.suspendLock;
            synchronized (object) {
                if (this.timeoutTask != null) {
                    this.timeoutTask.cancel();
                }
                this.timeoutTask = task;
            }
            try {
                TIMER.schedule(task, unit.toMillis(time));
            }
            catch (IllegalStateException ex) {
                logger.log(Level.WARNING, "Error while scheduling a timeout task.", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumed() {
        Object object = this.suspendLock;
        synchronized (object) {
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel();
            }
        }
    }

    protected abstract ContainerResponse handleResponse(ContainerResponse var1);

    protected abstract void release();
}

