/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import deprecated.javax.ws.rs.Suspend;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.NameBinding;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.Tokenizer;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.AnnotatedMethod;
import org.glassfish.jersey.server.model.BasicValidator;
import org.glassfish.jersey.server.model.MethodList;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModelIssue;

final class IntrospectionModeller {
    private static final Logger LOGGER = Logger.getLogger(IntrospectionModeller.class.getName());
    private final Class<?> handlerClass;
    private final List<ResourceModelIssue> issueList;

    public IntrospectionModeller(Class<?> handlerClass, List<ResourceModelIssue> issueList) {
        this.handlerClass = handlerClass;
        this.issueList = issueList;
    }

    private void addFatalIssue(Object source, String message) {
        this.issueList.add(new ResourceModelIssue(source, message, true));
    }

    private void addMinorIssue(Object source, String message) {
        this.issueList.add(new ResourceModelIssue(source, message, false));
    }

    public Resource.Builder createResourceBuilder(boolean skipAcceptableCheck) {
        if (!skipAcceptableCheck && !Resource.isAcceptable(this.handlerClass)) {
            this.addFatalIssue(this.handlerClass, LocalizationMessages.NON_INSTANTIABLE_CLASS(this.handlerClass));
        }
        this.checkForNonPublicMethodIssues();
        Class<?> annotatedResourceClass = IntrospectionModeller.getAnnotatedResourceClass(this.handlerClass);
        Path rPathAnnotation = annotatedResourceClass.getAnnotation(Path.class);
        boolean keepEncodedParams = null != annotatedResourceClass.getAnnotation(Encoded.class);
        List<MediaType> defaultConsumedTypes = IntrospectionModeller.extractMediaTypes(annotatedResourceClass.getAnnotation(Consumes.class));
        List<MediaType> defaultProducedTypes = IntrospectionModeller.extractMediaTypes(annotatedResourceClass.getAnnotation(Produces.class));
        Collection defaultNameBindings = ReflectionHelper.getAnnotationTypes(annotatedResourceClass, NameBinding.class);
        MethodList methodList = new MethodList(this.handlerClass);
        this.checkResourceClassSetters(methodList, keepEncodedParams);
        this.checkResourceClassFields(keepEncodedParams, BasicValidator.isSingleton(this.handlerClass));
        Resource.Builder resourceBuilder = null != rPathAnnotation ? Resource.builder(rPathAnnotation.value()) : Resource.builder();
        resourceBuilder.name(this.handlerClass.getName());
        this.addResourceMethods(resourceBuilder, methodList, keepEncodedParams, defaultConsumedTypes, defaultProducedTypes, defaultNameBindings);
        this.addSubResourceMethods(resourceBuilder, methodList, keepEncodedParams, defaultConsumedTypes, defaultProducedTypes, defaultNameBindings);
        this.addSubResourceLocators(resourceBuilder, methodList, keepEncodedParams);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(LocalizationMessages.NEW_AR_CREATED_BY_INTROSPECTION_MODELER(resourceBuilder.toString()));
        }
        return resourceBuilder;
    }

    private void checkForNonPublicMethodIssues() {
        MethodList allDeclaredMethods = new MethodList(this.getAllDeclaredMethods(this.handlerClass));
        for (AnnotatedMethod m : allDeclaredMethods.withMetaAnnotation(HttpMethod.class).withoutAnnotation(Path.class).isNotPublic()) {
            this.addMinorIssue(this.handlerClass, LocalizationMessages.NON_PUB_RES_METHOD(m.getMethod().toGenericString()));
        }
        for (AnnotatedMethod m : allDeclaredMethods.withMetaAnnotation(HttpMethod.class).withAnnotation(Path.class).isNotPublic()) {
            this.addMinorIssue(this.handlerClass, LocalizationMessages.NON_PUB_SUB_RES_METHOD(m.getMethod().toGenericString()));
        }
        for (AnnotatedMethod m : allDeclaredMethods.withoutMetaAnnotation(HttpMethod.class).withAnnotation(Path.class).isNotPublic()) {
            this.addMinorIssue(this.handlerClass, LocalizationMessages.NON_PUB_SUB_RES_LOC(m.getMethod().toGenericString()));
        }
    }

    private void checkResourceClassSetters(MethodList methodList, boolean encodedFlag) {
        for (AnnotatedMethod method : methodList.withoutMetaAnnotation(HttpMethod.class).withoutAnnotation(Path.class).hasNumParams(1).hasReturnType(Void.TYPE).nameStartsWith("set")) {
            Parameter p = Parameter.create(this.handlerClass, method.getMethod().getDeclaringClass(), encodedFlag || method.isAnnotationPresent(Encoded.class), method.getParameterTypes()[0], method.getGenericParameterTypes()[0], method.getAnnotations());
            if (null == p) continue;
            BasicValidator.validateParameter(this.issueList, p, method.getMethod(), method.getMethod().toGenericString(), "1", BasicValidator.isSingleton(this.handlerClass));
        }
    }

    private void checkResourceClassFields(boolean encodedFlag, boolean isInSingleton) {
        for (Field field : this.handlerClass.getDeclaredFields()) {
            Parameter p;
            if (field.getDeclaredAnnotations().length <= 0 || null == (p = Parameter.create(this.handlerClass, field.getDeclaringClass(), encodedFlag || field.isAnnotationPresent(Encoded.class), field.getType(), field.getGenericType(), field.getAnnotations()))) continue;
            BasicValidator.validateParameter(this.issueList, p, field, field.toGenericString(), field.getName(), isInSingleton);
        }
    }

    private List<Method> getAllDeclaredMethods(final Class<?> clazz) {
        final LinkedList<Method> result = new LinkedList<Method>();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (Class current = clazz; current != Object.class && current != null; current = current.getSuperclass()) {
                    result.addAll(Arrays.asList(current.getDeclaredMethods()));
                }
                return null;
            }
        });
        return result;
    }

    static Class<?> getAnnotatedResourceClass(Class<?> resourceClass) {
        if (resourceClass.isAnnotationPresent(Path.class)) {
            return resourceClass;
        }
        for (Class<?> i : resourceClass.getInterfaces()) {
            if (!i.isAnnotationPresent(Path.class)) continue;
            return i;
        }
        return resourceClass;
    }

    private static List<MediaType> resolveConsumedTypes(AnnotatedMethod am, List<MediaType> defaultConsumedTypes) {
        if (am.isAnnotationPresent(Consumes.class)) {
            return IntrospectionModeller.extractMediaTypes(am.getAnnotation(Consumes.class));
        }
        return defaultConsumedTypes;
    }

    private static List<MediaType> resolveProducedTypes(AnnotatedMethod am, List<MediaType> defaultProducedTypes) {
        if (am.isAnnotationPresent(Produces.class)) {
            return IntrospectionModeller.extractMediaTypes(am.getAnnotation(Produces.class));
        }
        return defaultProducedTypes;
    }

    private static List<MediaType> extractMediaTypes(Consumes annotation) {
        return annotation != null ? IntrospectionModeller.extractMediaTypes(annotation.value()) : Collections.emptyList();
    }

    private static List<MediaType> extractMediaTypes(Produces annotation) {
        return annotation != null ? IntrospectionModeller.extractMediaTypes(annotation.value()) : Collections.emptyList();
    }

    private static List<MediaType> extractMediaTypes(String[] values) {
        if (values.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<MediaType> types = new ArrayList<MediaType>(values.length);
        for (String mtEntry : values) {
            for (String mt : Tokenizer.tokenize((String)mtEntry, (String)",")) {
                types.add(MediaType.valueOf((String)mt));
            }
        }
        return types;
    }

    private static void declareSuspend(AnnotatedMethod am, ResourceMethod.Builder resourceMethodBuilder) {
        Suspend suspend = am.getAnnotation(Suspend.class);
        if (suspend != null) {
            resourceMethodBuilder.suspended(suspend.timeOut(), suspend.timeUnit());
        }
    }

    private void addResourceMethods(Resource.Builder resourceBuilder, MethodList methodList, boolean encodedParameters, List<MediaType> defaultConsumedTypes, List<MediaType> defaultProducedTypes, Collection<Class<? extends Annotation>> defaultNameBindings) {
        for (AnnotatedMethod am : methodList.withMetaAnnotation(HttpMethod.class).withoutAnnotation(Path.class)) {
            ResourceMethod.Builder methodBuilder = resourceBuilder.addMethod(am.getMetaMethodAnnotations(HttpMethod.class).get(0).value()).consumes(IntrospectionModeller.resolveConsumedTypes(am, defaultConsumedTypes)).produces(IntrospectionModeller.resolveProducedTypes(am, defaultProducedTypes)).encodedParameters(encodedParameters || am.isAnnotationPresent(Encoded.class)).nameBindings(defaultNameBindings).nameBindings(am.getAnnotations()).handledBy(this.handlerClass, am.getMethod());
            IntrospectionModeller.declareSuspend(am, methodBuilder);
        }
    }

    private void addSubResourceMethods(Resource.Builder resourceBuilder, MethodList methodList, boolean encodedParameters, List<MediaType> defaultConsumedTypes, List<MediaType> defaultProducedTypes, Collection<Class<? extends Annotation>> defaultNameBindings) {
        for (AnnotatedMethod am : methodList.withMetaAnnotation(HttpMethod.class).withAnnotation(Path.class)) {
            ResourceMethod.Builder methodBuilder = resourceBuilder.addMethod(am.getMetaMethodAnnotations(HttpMethod.class).get(0).value()).path(am.getAnnotation(Path.class).value()).consumes(IntrospectionModeller.resolveConsumedTypes(am, defaultConsumedTypes)).produces(IntrospectionModeller.resolveProducedTypes(am, defaultProducedTypes)).encodedParameters(encodedParameters || am.isAnnotationPresent(Encoded.class)).nameBindings(defaultNameBindings).nameBindings(am.getAnnotations()).handledBy(this.handlerClass, am.getMethod());
            IntrospectionModeller.declareSuspend(am, methodBuilder);
        }
    }

    private void addSubResourceLocators(Resource.Builder resourceBuilder, MethodList methodList, boolean encodedParameters) {
        for (AnnotatedMethod am : methodList.withoutMetaAnnotation(HttpMethod.class).withAnnotation(Path.class)) {
            resourceBuilder.addMethod().path(am.getAnnotation(Path.class).value()).encodedParameters(encodedParameters || am.isAnnotationPresent(Encoded.class)).handledBy(this.handlerClass, am.getMethod());
        }
    }
}

