/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.wadl.internal;

import java.util.List;
import java.util.logging.Logger;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.wadl.WadlApplicationContext;
import org.glassfish.jersey.server.wadl.internal.WadlApplicationContextImpl;

public final class WadlFactory {
    private static final Logger LOGGER = Logger.getLogger(WadlFactory.class.getName());
    private final boolean isWadlEnabled;
    private final ResourceConfig _resourceConfig;
    private WadlApplicationContext wadlApplicationContext;

    public WadlFactory(ResourceConfig resourceConfig) {
        this.isWadlEnabled = WadlFactory.isWadlEnabled(resourceConfig);
        this._resourceConfig = resourceConfig;
    }

    public boolean isSupported() {
        return this.isWadlEnabled;
    }

    public WadlApplicationContext createWadlApplicationContext(List<Resource> rootResources) {
        if (!this.isSupported()) {
            return null;
        }
        return new WadlApplicationContextImpl(rootResources, this._resourceConfig);
    }

    public void init(List<Resource> rootResources) {
        if (!this.isSupported()) {
            return;
        }
        this.wadlApplicationContext = new WadlApplicationContextImpl(rootResources, this._resourceConfig);
    }

    private static boolean isWadlEnabled(ResourceConfig resourceConfig) {
        return !resourceConfig.isProperty("jersey.config.server.wadl.disableWadl");
    }

    WadlApplicationContext getWadlApplicationContext() {
        return this.wadlApplicationContext;
    }
}

