/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.server.BroadcasterListener;
import org.glassfish.jersey.server.ChunkedResponse;
import org.glassfish.jersey.server.internal.LocalizationMessages;

public class Broadcaster<T>
implements BroadcasterListener<T> {
    private final ConcurrentSkipListSet<BroadcasterListener<T>> listeners = new ConcurrentSkipListSet(new Comparator<BroadcasterListener<T>>(){

        @Override
        public int compare(BroadcasterListener<T> listener1, BroadcasterListener<T> listener2) {
            return listener1.hashCode() - listener2.hashCode();
        }
    });
    private final ConcurrentSkipListSet<ChunkedResponse<T>> chunkedResponses = new ConcurrentSkipListSet(new Comparator<ChunkedResponse<T>>(){

        @Override
        public int compare(ChunkedResponse<T> chunkedResponse1, ChunkedResponse<T> chunkedResponse2) {
            return chunkedResponse1.hashCode() - chunkedResponse2.hashCode();
        }
    });

    public Broadcaster() {
        this(Broadcaster.class);
    }

    protected Broadcaster(Class<? extends Broadcaster> subclass) {
        if (subclass != this.getClass()) {
            this.listeners.add(this);
        }
    }

    public final boolean add(ChunkedResponse<T> chunkedResponse) {
        return this.chunkedResponses.add(chunkedResponse);
    }

    public final boolean remove(ChunkedResponse<T> chunkedResponse) {
        return this.chunkedResponses.remove(chunkedResponse);
    }

    public final boolean addBroadcasterListener(BroadcasterListener<T> listener) {
        return this.listeners.add(listener);
    }

    public final boolean removeBroadcasterListener(BroadcasterListener<T> listener) {
        return this.listeners.remove(listener);
    }

    public void broadcast(final T chunk) {
        this.forEachChunkedResponse(new Task<ChunkedResponse<T>>(){

            @Override
            public void run(ChunkedResponse<T> cr) throws IOException {
                cr.write(chunk);
            }
        });
    }

    public void closeAll() {
        this.forEachChunkedResponse(new Task<ChunkedResponse<T>>(){

            @Override
            public void run(ChunkedResponse<T> cr) throws IOException {
                cr.close();
            }
        });
    }

    @Override
    public void onException(ChunkedResponse<T> chunkedResponse, Exception exception) {
    }

    @Override
    public void onClose(ChunkedResponse<T> chunkedResponse) {
    }

    private void forEachChunkedResponse(Task<ChunkedResponse<T>> t) {
        Iterator<ChunkedResponse<T>> iterator = this.chunkedResponses.iterator();
        while (iterator.hasNext()) {
            ChunkedResponse<T> chunkedResponse = iterator.next();
            if (!chunkedResponse.isClosed()) {
                try {
                    t.run(chunkedResponse);
                }
                catch (Exception e) {
                    this.fireOnException(chunkedResponse, e);
                }
            }
            if (!chunkedResponse.isClosed()) continue;
            iterator.remove();
            this.fireOnClose(chunkedResponse);
        }
    }

    private void forEachListener(Task<BroadcasterListener<T>> t) {
        for (BroadcasterListener<T> listener : this.listeners) {
            try {
                t.run(listener);
            }
            catch (Exception e) {
                Logger.getLogger(Broadcaster.class.getName()).log(Level.WARNING, LocalizationMessages.BROADCASTER_LISTENER_EXCEPTION(e.getClass().getSimpleName()), e);
            }
        }
    }

    private void fireOnException(final ChunkedResponse<T> chunkedResponse, final Exception exception) {
        this.forEachListener(new Task<BroadcasterListener<T>>(){

            @Override
            public void run(BroadcasterListener<T> parameter) throws IOException {
                parameter.onException(chunkedResponse, exception);
            }
        });
    }

    private void fireOnClose(final ChunkedResponse<T> chunkedResponse) {
        this.forEachListener(new Task<BroadcasterListener<T>>(){

            @Override
            public void run(BroadcasterListener<T> parameter) throws IOException {
                parameter.onClose(chunkedResponse);
            }
        });
    }

    private static interface Task<T> {
        public void run(T var1) throws IOException;
    }
}

