/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.Config;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.Tokenizer;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.scanning.AnnotationAcceptingListener;
import org.glassfish.jersey.server.internal.scanning.FilesScanner;
import org.glassfish.jersey.server.internal.scanning.PackageNamesScanner;
import org.glassfish.jersey.server.model.Resource;

public class ResourceConfig
extends Application
implements Config {
    private static final Logger LOGGER = Logger.getLogger(ResourceConfig.class.getName());
    private transient Set<Class<?>> cachedClasses = null;
    private transient Set<Class<?>> cachedClassesView = null;
    private transient Set<Object> cachedSingletons = null;
    private transient Set<Object> cachedSingletonsView = null;
    private final Set<Class<?>> classes;
    private final Set<Object> singletons;
    private final Set<ResourceFinder> resourceFinders;
    private final Set<Resource> resources;
    private final Set<Resource> resourcesView;
    private final Map<String, Object> properties;
    private final Map<String, Object> propertiesView;
    private final Set<Binder> customBinders;
    private ClassLoader classLoader = null;
    private InternalState internalState = new Mutable();

    public ResourceConfig() {
        this.classLoader = ReflectionHelper.getContextClassLoader();
        this.classes = Sets.newHashSet();
        this.singletons = Sets.newHashSet();
        this.resources = Sets.newHashSet();
        this.resourcesView = Collections.unmodifiableSet(this.resources);
        this.properties = Maps.newHashMap();
        this.propertiesView = Collections.unmodifiableMap(this.properties);
        this.resourceFinders = Sets.newHashSet();
        this.customBinders = Sets.newHashSet();
    }

    public ResourceConfig(Set<Class<?>> classes) {
        this();
        this.addClasses(classes);
    }

    public ResourceConfig(Class<?> ... classes) {
        this(Sets.newHashSet((Object[])classes));
    }

    public static ResourceConfig forApplication(Application application) {
        return application instanceof ResourceConfig ? (ResourceConfig)application : new WrappingResourceConfig(application, null, null);
    }

    public static ResourceConfig forApplicationClass(Class<? extends Application> applicationClass) {
        return new WrappingResourceConfig(null, applicationClass, null);
    }

    public static ResourceConfig forApplicationClass(Class<? extends Application> applicationClass, Set<Class<?>> defaultClasses) {
        return new WrappingResourceConfig(null, applicationClass, defaultClasses);
    }

    public final ResourceConfig addClasses(Set<Class<?>> classes) {
        return this.internalState.addClasses(classes);
    }

    public final ResourceConfig addClasses(Class<?> ... classes) {
        return this.addClasses(Sets.newHashSet((Object[])classes));
    }

    public final ResourceConfig addSingletons(Set<Object> singletons) {
        return this.internalState.addSingletons(singletons);
    }

    public final ResourceConfig addSingletons(Object ... singletons) {
        return this.addSingletons(Sets.newHashSet((Object[])singletons));
    }

    public final ResourceConfig addResources(Resource ... resources) {
        return this.addResources(Sets.newHashSet((Object[])resources));
    }

    public final ResourceConfig addResources(Set<Resource> resources) {
        return this.internalState.addResources(resources);
    }

    public ResourceConfig setProperty(String name, Object value) {
        return this.internalState.setProperty(name, value);
    }

    public final ResourceConfig addProperties(Map<String, Object> properties) {
        return this.internalState.addProperties(properties);
    }

    public final ResourceConfig addFinder(ResourceFinder resourceFinder) {
        return this.internalState.addFinder(resourceFinder);
    }

    public final ResourceConfig addBinders(Set<Binder> binders) {
        return this.internalState.addBinders(binders);
    }

    public final ResourceConfig addBinders(Binder ... binders) {
        return this.addBinders(Sets.newHashSet((Object[])binders));
    }

    public final ResourceConfig setClassLoader(ClassLoader classLoader) {
        return this.internalState.setClassLoader(classLoader);
    }

    public final ResourceConfig packages(String ... packages) {
        return this.addFinder(new PackageNamesScanner(packages));
    }

    public final ResourceConfig files(String ... files) {
        return this.addFinder(new FilesScanner(files));
    }

    private void invalidateCache() {
        this.cachedClasses = null;
        this.cachedClassesView = null;
        this.cachedSingletons = null;
        this.cachedSingletonsView = null;
    }

    final Set<Binder> getCustomBinders() {
        return this.customBinders;
    }

    void lock() {
        if (!(this.internalState instanceof Immutable)) {
            this.internalState = new Immutable();
        }
    }

    public final Set<Class<?>> getClasses() {
        if (this.cachedClassesView == null) {
            this.cachedClasses = this._getClasses();
            this.cachedClassesView = Collections.unmodifiableSet(this.cachedClasses);
        }
        return this.cachedClassesView;
    }

    Set<Class<?>> _getClasses() {
        String[] classPathElements;
        String[] packageNames;
        HashSet result = Sets.newHashSet();
        HashSet rfs = Sets.newHashSet(this.resourceFinders);
        String[] classNames = this.parsePropertyValue("jersey.config.server.provider.classnames");
        if (classNames != null) {
            for (String className : classNames) {
                try {
                    result.add(this.classLoader.loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.log(Level.CONFIG, LocalizationMessages.UNABLE_TO_LOAD_CLASS(className));
                }
            }
        }
        if ((packageNames = this.parsePropertyValue("jersey.config.server.provider.packages")) != null) {
            rfs.add(new PackageNamesScanner(packageNames));
        }
        if ((classPathElements = this.parsePropertyValue("jersey.config.server.provider.classpath")) != null) {
            rfs.add(new FilesScanner(classPathElements));
        }
        AnnotationAcceptingListener afl = AnnotationAcceptingListener.newJaxrsResourceAndProviderListener(this.classLoader);
        for (ResourceFinder resourceFinder : rfs) {
            while (resourceFinder.hasNext()) {
                String next = (String)resourceFinder.next();
                if (!afl.accept(next)) continue;
                try {
                    afl.process(next, resourceFinder.open());
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Unable to process {0}", next);
                }
            }
        }
        result.addAll(afl.getAnnotatedClasses());
        result.addAll(this.classes);
        return result;
    }

    private String[] parsePropertyValue(String propertyName) {
        String[] classNames = null;
        Object o = this.properties.get(propertyName);
        if (o != null) {
            if (o instanceof String) {
                classNames = Tokenizer.tokenize((String)((String)o));
            } else if (o instanceof String[]) {
                classNames = Tokenizer.tokenize((String[])((String[])o));
            }
        }
        return classNames;
    }

    public final Set<Object> getSingletons() {
        if (this.cachedSingletonsView == null) {
            this.cachedSingletons = this._getSingletons();
            this.cachedSingletonsView = Collections.unmodifiableSet(this.cachedSingletons);
        }
        return this.cachedSingletonsView;
    }

    Set<Object> _getSingletons() {
        HashSet result = Sets.newHashSet();
        result.addAll(this.singletons);
        return result;
    }

    public final Set<Resource> getResources() {
        return this.resourcesView;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final Map<String, Object> getProperties() {
        return this.propertiesView;
    }

    public final Object getProperty(String name) {
        return this.properties.get(name);
    }

    public final boolean isProperty(String name) {
        if (this.properties.containsKey(name)) {
            Object value = this.properties.get(name);
            if (value instanceof Boolean) {
                return (Boolean)Boolean.class.cast(value);
            }
            return Boolean.parseBoolean(value.toString());
        }
        return false;
    }

    public final Application getApplication() {
        return this._getApplication();
    }

    Application _getApplication() {
        return this;
    }

    Class<? extends Application> getApplicationClass() {
        return null;
    }

    final ResourceConfig setApplication(Application app) {
        this.internalState.setApplication(app);
        return this;
    }

    ResourceConfig _setApplication(Application app) {
        throw new UnsupportedOperationException();
    }

    private static class WrappingResourceConfig
    extends ResourceConfig {
        private Application application;
        private Class<? extends Application> applicationClass;
        private final Set<Class<?>> defaultClasses = Sets.newHashSet();

        public WrappingResourceConfig(Application application, Class<? extends Application> applicationClass, Set<Class<?>> defaultClasses) {
            if (application == null && applicationClass == null) {
                throw new IllegalArgumentException("Both application and applicationClass can't be null.");
            }
            this.application = application;
            this.applicationClass = applicationClass;
            if (defaultClasses != null) {
                this.defaultClasses.addAll(defaultClasses);
            }
            this.mergeApplications(application);
        }

        @Override
        ResourceConfig _setApplication(Application application) {
            this.application = application;
            this.applicationClass = null;
            this.mergeApplications(application);
            return this;
        }

        @Override
        Application _getApplication() {
            return this.application;
        }

        @Override
        Class<? extends Application> getApplicationClass() {
            return this.applicationClass;
        }

        private void mergeApplications(Application application) {
            if (application instanceof ResourceConfig) {
                ResourceConfig rc = (ResourceConfig)application;
                ((ResourceConfig)this).customBinders.addAll(rc.customBinders);
                ((ResourceConfig)this).resources.addAll(rc.resources);
                rc.invalidateCache();
                rc.properties.putAll(((ResourceConfig)this).properties);
                ((ResourceConfig)this).properties.putAll(rc.properties);
                rc.lock();
            }
        }

        @Override
        Set<Class<?>> _getClasses() {
            HashSet result = Sets.newHashSet();
            result.addAll(this.application.getClasses());
            if (result.isEmpty() && this.getSingletons().isEmpty()) {
                result.addAll(this.defaultClasses);
            }
            if (!(this.application instanceof ResourceConfig)) {
                result.addAll(super._getClasses());
            }
            return result;
        }

        @Override
        Set<Object> _getSingletons() {
            return this.application.getSingletons();
        }
    }

    private class Mutable
    implements InternalState {
        private Mutable() {
        }

        @Override
        public ResourceConfig addClasses(Set<Class<?>> classes) {
            ResourceConfig.this.invalidateCache();
            ResourceConfig.this.classes.addAll(classes);
            return ResourceConfig.this;
        }

        @Override
        public ResourceConfig addResources(Set<Resource> resources) {
            ResourceConfig.this.resources.addAll(resources);
            return ResourceConfig.this;
        }

        @Override
        public ResourceConfig addFinder(ResourceFinder resourceFinder) {
            ResourceConfig.this.invalidateCache();
            ResourceConfig.this.resourceFinders.add(resourceFinder);
            return ResourceConfig.this;
        }

        @Override
        public ResourceConfig addBinders(Set<Binder> binders) {
            ResourceConfig.this.customBinders.addAll(binders);
            return ResourceConfig.this;
        }

        @Override
        public ResourceConfig addProperties(Map<String, Object> properties) {
            ResourceConfig.this.invalidateCache();
            ResourceConfig.this.properties.putAll(properties);
            return ResourceConfig.this;
        }

        @Override
        public ResourceConfig addSingletons(Set<Object> singletons) {
            ResourceConfig.this.invalidateCache();
            ResourceConfig.this.singletons.addAll(singletons);
            return ResourceConfig.this;
        }

        @Override
        public ResourceConfig setClassLoader(ClassLoader classLoader) {
            ResourceConfig.this.invalidateCache();
            ResourceConfig.this.classLoader = classLoader;
            return ResourceConfig.this;
        }

        @Override
        public ResourceConfig setProperty(String name, Object value) {
            ResourceConfig.this.invalidateCache();
            ResourceConfig.this.properties.put(name, value);
            return ResourceConfig.this;
        }

        @Override
        public ResourceConfig setApplication(Application application) {
            ResourceConfig.this.invalidateCache();
            return ResourceConfig.this._setApplication(application);
        }
    }

    private class Immutable
    implements InternalState {
        private Immutable() {
        }

        @Override
        public ResourceConfig addClasses(Set<Class<?>> classes) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig addResources(Set<Resource> resources) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig addFinder(ResourceFinder resourceFinder) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig addBinders(Set<Binder> binders) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig addProperties(Map<String, Object> properties) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig addSingletons(Set<Object> singletons) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig setClassLoader(ClassLoader classLoader) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig setProperty(String name, Object value) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }

        @Override
        public ResourceConfig setApplication(Application application) {
            throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
        }
    }

    private static interface InternalState {
        public ResourceConfig addClasses(Set<Class<?>> var1);

        public ResourceConfig addResources(Set<Resource> var1);

        public ResourceConfig addFinder(ResourceFinder var1);

        public ResourceConfig addBinders(Set<Binder> var1);

        public ResourceConfig addProperties(Map<String, Object> var1);

        public ResourceConfig addSingletons(Set<Object> var1);

        public ResourceConfig setClassLoader(ClassLoader var1);

        public ResourceConfig setProperty(String var1, Object var2);

        public ResourceConfig setApplication(Application var1);
    }
}

