/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.JerseyResourceContext;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.spi.internal.ParameterValueHelper;

class SubResourceLocatorRouter
implements Router {
    private final ServiceLocator locator;
    private final ResourceMethod locatorModel;
    private final List<Factory<?>> valueProviders;
    private final RuntimeModelBuilder runtimeModelBuilderOriginal;
    private final JerseyResourceContext resourceContext;

    public SubResourceLocatorRouter(ServiceLocator locator, RuntimeModelBuilder runtimeModelBuilderOriginal, ResourceMethod locatorModel) {
        this.locator = locator;
        this.runtimeModelBuilderOriginal = runtimeModelBuilderOriginal;
        this.locatorModel = locatorModel;
        this.valueProviders = ParameterValueHelper.createValueProviders(locator, locatorModel.getInvocable());
        this.resourceContext = (JerseyResourceContext)locator.getService(JerseyResourceContext.class, new Annotation[0]);
    }

    @Override
    public Router.Continuation apply(ContainerRequest request) {
        RoutingContext routingCtx = (RoutingContext)Injections.getOrCreate((ServiceLocator)this.locator, RoutingContext.class);
        Object subResource = this.getResource(routingCtx);
        if (subResource == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (subResource.getClass().isAssignableFrom(Class.class)) {
            Class clazz = (Class)subResource;
            this.resourceContext.bindResource(clazz);
            subResource = Injections.getOrCreate((ServiceLocator)this.locator, (Class)clazz);
        }
        this.resourceContext.bindResourceIfSingleton(subResource);
        Resource subResourceModel = Resource.builder(subResource, new LinkedList<ResourceModelIssue>()).build();
        RuntimeModelBuilder runtimeModelBuilder = this.runtimeModelBuilderOriginal.copy();
        runtimeModelBuilder.process(subResourceModel, true);
        routingCtx.pushMatchedResource(subResource);
        Router subResourceAcceptor = runtimeModelBuilder.buildModel(true);
        return Router.Continuation.of(request, subResourceAcceptor);
    }

    private Object getResource(RoutingContext routingCtx) {
        Object resource = routingCtx.peekMatchedResource();
        try {
            Method handlingMethod = this.locatorModel.getInvocable().getHandlingMethod();
            return handlingMethod.invoke(resource, ParameterValueHelper.getParameterValues(this.valueProviders));
        }
        catch (IllegalAccessException ex) {
            throw new ProcessingException("Resource Java method invocation error.", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ProcessingException) {
                throw (ProcessingException)cause;
            }
            throw new MappableException(cause);
        }
        catch (UndeclaredThrowableException ex) {
            throw new ProcessingException("Resource Java method invocation error.", (Throwable)ex);
        }
        catch (ProcessingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MappableException(ex);
        }
        catch (Throwable t) {
            throw new ProcessingException(t);
        }
    }
}

