/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.wadl.internal.generators;

import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Method;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl.Representation;
import com.sun.research.ws.wadl.Request;
import com.sun.research.ws.wadl.Resources;
import com.sun.research.ws.wadl.Response;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.wadl.WadlGenerator;
import org.glassfish.jersey.server.wadl.internal.ApplicationDescription;
import org.glassfish.jersey.server.wadl.internal.WadlGeneratorImpl;

public class WadlGeneratorJAXBGrammarGenerator
implements WadlGenerator {
    private static final Logger LOGGER = Logger.getLogger(WadlGeneratorJAXBGrammarGenerator.class.getName());
    private static final Set<Class> SPECIAL_GENERIC_TYPES = new HashSet<Class>(){
        {
            this.add(List.class);
        }
    };
    private WadlGenerator _delegate = new WadlGeneratorImpl();
    private Set<Class> _seeAlso;
    private List<Pair> _hasTypeWantsName;

    private static HasType parameter(final Parameter param) {
        return new HasType(){

            @Override
            public Class getPrimaryClass() {
                return param.getRawType();
            }

            @Override
            public Type getType() {
                return param.getType();
            }
        };
    }

    @Override
    public void setWadlGeneratorDelegate(WadlGenerator delegate) {
        this._delegate = delegate;
    }

    @Override
    public String getRequiredJaxbContextPath() {
        return this._delegate.getRequiredJaxbContextPath();
    }

    @Override
    public void init() throws IllegalStateException, JAXBException {
        this._delegate.init();
        this._seeAlso = new HashSet<Class>();
        this._hasTypeWantsName = new ArrayList<Pair>();
    }

    @Override
    public Application createApplication() {
        return this._delegate.createApplication();
    }

    @Override
    public Method createMethod(Resource ar, ResourceMethod arm) {
        return this._delegate.createMethod(ar, arm);
    }

    @Override
    public Request createRequest(Resource ar, ResourceMethod arm) {
        return this._delegate.createRequest(ar, arm);
    }

    @Override
    public Param createParam(Resource ar, ResourceMethod am, Parameter p) {
        final Param param = this._delegate.createParam(ar, am, p);
        if (p.getSource() == Parameter.Source.ENTITY) {
            this._hasTypeWantsName.add(new Pair(WadlGeneratorJAXBGrammarGenerator.parameter(p), new WantsName(){

                @Override
                public void setName(QName name) {
                    param.setType(name);
                }
            }));
        }
        return param;
    }

    @Override
    public Representation createRequestRepresentation(Resource ar, ResourceMethod arm, MediaType mt) {
        Representation rt = this._delegate.createRequestRepresentation(ar, arm, mt);
        return rt;
    }

    @Override
    public com.sun.research.ws.wadl.Resource createResource(Resource ar, String path) {
        return this._delegate.createResource(ar, path);
    }

    @Override
    public Resources createResources() {
        return this._delegate.createResources();
    }

    @Override
    public List<Response> createResponses(Resource ar, final ResourceMethod arm) {
        List<Response> responses = this._delegate.createResponses(ar, arm);
        if (responses != null) {
            HasType hasType = new HasType(){

                @Override
                public Class getPrimaryClass() {
                    return arm.getInvocable().getRawResponseType();
                }

                @Override
                public Type getType() {
                    return arm.getInvocable().getResponseType();
                }
            };
            for (Response response : responses) {
                for (final Representation representation : response.getRepresentation()) {
                    this._hasTypeWantsName.add(new Pair(hasType, new WantsName(){

                        @Override
                        public void setName(QName name) {
                            representation.setElement(name);
                        }
                    }));
                }
            }
        }
        return responses;
    }

    @Override
    public WadlGenerator.ExternalGrammarDefinition createExternalGrammar() {
        HashMap<String, ApplicationDescription.ExternalGrammar> extraFiles = new HashMap<String, ApplicationDescription.ExternalGrammar>();
        WadlGenerator.Resolver resolver = this.buildModelAndSchemas(extraFiles);
        WadlGenerator.ExternalGrammarDefinition previous = this._delegate.createExternalGrammar();
        previous.map.putAll(extraFiles);
        if (resolver != null) {
            previous.addResolver(resolver);
        }
        return previous;
    }

    private WadlGenerator.Resolver buildModelAndSchemas(Map<String, ApplicationDescription.ExternalGrammar> extraFiles) {
        HashSet<Class> classSet = new HashSet<Class>(this._seeAlso);
        for (Pair pair : this._hasTypeWantsName) {
            Type parameterType;
            Type type;
            HasType hasType = pair.hasType;
            Class clazz = hasType.getPrimaryClass();
            if (clazz.getAnnotation(XmlRootElement.class) != null) {
                classSet.add(clazz);
                continue;
            }
            if (!SPECIAL_GENERIC_TYPES.contains(clazz) || !((type = hasType.getType()) instanceof ParameterizedType) || !((parameterType = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class)) continue;
            classSet.add((Class)parameterType);
        }
        JAXBIntrospector introspector = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])classSet.toArray(new Class[classSet.size()]));
            final ArrayList results = new ArrayList();
            context.generateSchema(new SchemaOutputResolver(){
                int counter = 0;

                public Result createOutput(String namespaceUri, String suggestedFileName) {
                    StreamResult result = new StreamResult(new CharArrayWriter());
                    result.setSystemId("xsd" + this.counter++ + ".xsd");
                    results.add(result);
                    return result;
                }
            });
            for (StreamResult result : results) {
                CharArrayWriter writer = (CharArrayWriter)result.getWriter();
                byte[] contents = writer.toString().getBytes("UTF8");
                extraFiles.put(result.getSystemId(), new ApplicationDescription.ExternalGrammar(MediaType.APPLICATION_XML_TYPE, contents));
            }
            introspector = context.createJAXBIntrospector();
        }
        catch (JAXBException e) {
            LOGGER.log(Level.SEVERE, "Failed to generate the schema for the JAX-B elements", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to generate the schema for the JAX-B elements due to an IO error", e);
        }
        if (introspector != null) {
            final JAXBIntrospector copy = introspector;
            return new WadlGenerator.Resolver(){

                @Override
                public QName resolve(Class type) {
                    Object parameterClassInstance = null;
                    try {
                        Constructor defaultConstructor = type.getDeclaredConstructor(new Class[0]);
                        defaultConstructor.setAccessible(true);
                        parameterClassInstance = defaultConstructor.newInstance(new Object[0]);
                    }
                    catch (InstantiationException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                    }
                    catch (IllegalAccessException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                    }
                    catch (InvocationTargetException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                    }
                    catch (SecurityException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                    }
                    catch (NoSuchMethodException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                    }
                    if (parameterClassInstance == null) {
                        return null;
                    }
                    try {
                        return copy.getElementName(parameterClassInstance);
                    }
                    catch (NullPointerException e) {
                        return null;
                    }
                }
            };
        }
        return null;
    }

    @Override
    public void attachTypes(ApplicationDescription introspector) {
        if (introspector != null) {
            int i = this._hasTypeWantsName.size();
            for (int j = 0; j < i; ++j) {
                QName name;
                Pair pair = this._hasTypeWantsName.get(j);
                WantsName nextToProcess = pair.wantsName;
                HasType nextType = pair.hasType;
                Class parameterClass = nextType.getPrimaryClass();
                if (SPECIAL_GENERIC_TYPES.contains(parameterClass)) {
                    Type type = nextType.getType();
                    if (ParameterizedType.class.isAssignableFrom(type.getClass()) && Class.class.isAssignableFrom(((ParameterizedType)type).getActualTypeArguments()[0].getClass())) {
                        parameterClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                    } else {
                        LOGGER.fine("Couldn't find JAX-B element due to nested parameterized type " + type);
                        return;
                    }
                }
                if ((name = introspector.resolve(parameterClass)) != null) {
                    nextToProcess.setName(name);
                    continue;
                }
                LOGGER.fine("Couldn't find JAX-B element for class " + parameterClass.getName());
            }
        }
    }

    private class Pair {
        HasType hasType;
        WantsName wantsName;

        public Pair(HasType hasType, WantsName wantsName) {
            this.hasType = hasType;
            this.wantsName = wantsName;
        }
    }

    private static interface WantsName {
        public void setName(QName var1);
    }

    private static interface HasType {
        public Class getPrimaryClass();

        public Type getType();
    }
}

