/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ParamConverter;
import org.glassfish.jersey.server.internal.inject.AbstractParamValueExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;

abstract class CollectionExtractor<T>
extends AbstractParamValueExtractor<T>
implements MultivaluedParameterExtractor<Collection<T>> {
    protected CollectionExtractor(ParamConverter<T> converter, String parameter, String defaultStringValue) {
        super(converter, parameter, defaultStringValue);
    }

    @Override
    public Collection<T> extract(MultivaluedMap<String, String> parameters) {
        List stringList = (List)parameters.get((Object)this.getName());
        Collection<T> valueList = this.getInstance();
        if (stringList != null) {
            for (String v : stringList) {
                valueList.add(this.fromString(v));
            }
        } else if (this.isDefaultValueRegistered()) {
            valueList.add(this.defaultValue());
        }
        return valueList;
    }

    protected abstract Collection<T> getInstance();

    public static <T> MultivaluedParameterExtractor getInstance(Class<?> c, ParamConverter<T> converter, String parameter, String defaultValueString) {
        if (List.class == c) {
            return new ListValueOf<T>(converter, parameter, defaultValueString);
        }
        if (Set.class == c) {
            return new SetValueOf<T>(converter, parameter, defaultValueString);
        }
        if (SortedSet.class == c) {
            return new SortedSetValueOf<T>(converter, parameter, defaultValueString);
        }
        throw new RuntimeException();
    }

    private static final class SortedSetValueOf<T>
    extends CollectionExtractor<T> {
        SortedSetValueOf(ParamConverter<T> converter, String parameter, String defaultValueString) {
            super(converter, parameter, defaultValueString);
        }

        @Override
        protected SortedSet<T> getInstance() {
            return new TreeSet();
        }
    }

    private static final class SetValueOf<T>
    extends CollectionExtractor<T> {
        SetValueOf(ParamConverter<T> converter, String parameter, String defaultValueString) {
            super(converter, parameter, defaultValueString);
        }

        @Override
        protected Set<T> getInstance() {
            return new HashSet();
        }
    }

    private static final class ListValueOf<T>
    extends CollectionExtractor<T> {
        ListValueOf(ParamConverter<T> converter, String parameter, String defaultValueString) {
            super(converter, parameter, defaultValueString);
        }

        @Override
        protected List<T> getInstance() {
            return new ArrayList();
        }
    }
}

