/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractFuture;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.NameBinding;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.BindingBuilder;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.ProviderBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.model.internal.FeatureBag;
import org.glassfish.jersey.model.internal.ProviderBag;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerFilteringStage;
import org.glassfish.jersey.server.ContainerMessageBodyWorkersInitializer;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ReferencesInitializer;
import org.glassfish.jersey.server.ResourceBag;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerBinder;
import org.glassfish.jersey.server.ServerRuntime;
import org.glassfish.jersey.server.internal.JerseyResourceContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.routing.RoutedInflectorExtractorStage;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingStage;
import org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import org.glassfish.jersey.server.model.BasicValidator;
import org.glassfish.jersey.server.model.ModelValidationException;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.internal.ModelErrors;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.wadl.WadlApplicationContext;
import org.glassfish.jersey.server.wadl.internal.WadlApplicationContextImpl;
import org.glassfish.jersey.server.wadl.internal.WadlResource;
import org.glassfish.jersey.spi.Errors;

public final class ApplicationHandler {
    private static final Logger LOGGER = Logger.getLogger(ApplicationHandler.class.getName());
    private static final SecurityContext DEFAULT_SECURITY_CONTEXT = new SecurityContext(){

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    };
    private final Application application;
    private final ResourceConfig.RuntimeResourceConfig resourceConfig;
    private final ServiceLocator locator;
    private ServerRuntime runtime;

    public ApplicationHandler() {
        this.application = new Application();
        this.resourceConfig = new ResourceConfig.RuntimeResourceConfig();
        this.locator = Injections.createLocator((Binder[])new Binder[]{new ServerBinder(), new ApplicationBinder()});
        Errors.processWithException((Errors.Closure)new Errors.Closure<Void>(){

            public Void invoke() {
                ApplicationHandler.this.initialize();
                return null;
            }
        });
    }

    public ApplicationHandler(Class<? extends Application> jaxrsApplicationClass) {
        this.locator = Injections.createLocator((Binder[])new Binder[]{new ServerBinder(), new ApplicationBinder()});
        this.application = this.createApplication(jaxrsApplicationClass);
        this.resourceConfig = this.createResourceConfig(this.application);
        Errors.processWithException((Errors.Closure)new Errors.Closure<Void>(){

            public Void invoke() {
                ApplicationHandler.this.initialize();
                return null;
            }
        });
    }

    public ApplicationHandler(Application application) {
        this.locator = Injections.createLocator((Binder[])new Binder[]{new ServerBinder(), new ApplicationBinder()});
        this.application = application;
        this.resourceConfig = this.createResourceConfig(application);
        Errors.processWithException((Errors.Closure)new Errors.Closure<Void>(){

            public Void invoke() {
                ApplicationHandler.this.initialize();
                return null;
            }
        });
    }

    private ResourceConfig.RuntimeResourceConfig createResourceConfig(Application application) {
        ResourceConfig resourceConfig;
        Class<? extends Application> applicationClass;
        if (application instanceof ResourceConfig && (applicationClass = (resourceConfig = (ResourceConfig)application).getApplicationClass()) != null) {
            Application app = this.createApplication(applicationClass);
            this.registerAdditionalBinders(resourceConfig.getCustomBinders());
            resourceConfig.setApplication(app);
        }
        return ResourceConfig.newRuntimeResourceConfig(application);
    }

    private void initialize() {
        Resource resource;
        LOGGER.info(LocalizationMessages.INIT_MSG(Version.getBuildId()));
        if (this.application instanceof ResourceConfig) {
            ((ResourceConfig)this.application).lock();
        }
        this.registerAdditionalBinders(this.resourceConfig.getCustomBinders());
        ResourceBag.Builder resourceBagBuilder = new ResourceBag.Builder();
        HashSet classes = new HashSet(this.resourceConfig.getClasses());
        boolean wadlDisabled = this.resourceConfig.isProperty("jersey.config.server.wadl.disableWadl");
        if (!wadlDisabled) {
            classes.add(WadlResource.class);
        }
        for (Class clazz : classes) {
            if (clazz == null) {
                LOGGER.warning(LocalizationMessages.NON_INSTANTIABLE_CLASS(clazz));
                break;
            }
            try {
                resource = Resource.from(clazz);
                if (resource != null) {
                    resourceBagBuilder.registerResource(clazz, resource, this.resourceConfig.getProviderBag().getContractProvider(clazz));
                    continue;
                }
                this.resourceConfig.register(clazz);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning(ex.getMessage());
            }
        }
        for (Object object : this.resourceConfig.getSingletons()) {
            if (object == null) {
                LOGGER.warning(LocalizationMessages.NON_INSTANTIABLE_CLASS(object));
                break;
            }
            try {
                resource = Resource.from(object);
                if (resource != null) {
                    resourceBagBuilder.registerResource(object, resource, this.resourceConfig.getProviderBag().getContractProvider(object.getClass()));
                    continue;
                }
                this.resourceConfig.register(object);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning(ex.getMessage());
            }
        }
        ProviderBinder.configureFeatures((FeatureBag)this.resourceConfig.getFeatureBag(), (Configurable)this.resourceConfig, (ServiceLocator)this.locator);
        this.resourceConfig.lock();
        for (Resource resource2 : this.resourceConfig.getResources()) {
            resourceBagBuilder.registerProgrammaticResource(resource2);
        }
        ResourceBag resourceBag = resourceBagBuilder.build();
        ProviderBag providerBag = this.resourceConfig.getProviderBag();
        HashSet<ComponentProvider> componentProviders = new HashSet<ComponentProvider>();
        for (ComponentProvider provider : ServiceFinder.find(ComponentProvider.class)) {
            provider.initialize(this.locator);
            componentProviders.add(provider);
        }
        this.registerProvidersAndResources(componentProviders, providerBag, resourceBag);
        for (ComponentProvider componentProvider : componentProviders) {
            componentProvider.done();
        }
        Collection applicationNameBindings = ReflectionHelper.getAnnotationTypes(this.application.getClass(), NameBinding.class);
        Iterable responseFilters = Providers.getAllRankedProviders((ServiceLocator)this.locator, ContainerResponseFilter.class);
        MultivaluedMap nameBoundResponseFilters = ApplicationHandler.filterNameBound(responseFilters, null, providerBag, applicationNameBindings);
        Iterable requestFilters = Providers.getAllRankedProviders((ServiceLocator)this.locator, ContainerRequestFilter.class);
        ArrayList preMatchFilters = Lists.newArrayList();
        MultivaluedMap nameBoundRequestFilters = ApplicationHandler.filterNameBound(requestFilters, preMatchFilters, providerBag, applicationNameBindings);
        Iterable readerInterceptors = Providers.getAllRankedProviders((ServiceLocator)this.locator, ReaderInterceptor.class);
        MultivaluedMap nameBoundReaderInterceptors = ApplicationHandler.filterNameBound(readerInterceptors, null, providerBag, applicationNameBindings);
        Iterable writerInterceptors = Providers.getAllRankedProviders((ServiceLocator)this.locator, WriterInterceptor.class);
        MultivaluedMap nameBoundWriterInterceptors = ApplicationHandler.filterNameBound(writerInterceptors, null, providerBag, applicationNameBindings);
        Iterable dynamicFeatures = Providers.getAllProviders((ServiceLocator)this.locator, DynamicFeature.class);
        this.validate(resourceBag.models);
        DynamicConfiguration dynamicConfiguration = Injections.getConfiguration((ServiceLocator)this.locator);
        Injections.addBinding((BindingBuilder)Injections.newBinder((Object)new WadlApplicationContextImpl(resourceBag.getRootResources(), this.resourceConfig)).to(WadlApplicationContext.class), (DynamicConfiguration)dynamicConfiguration);
        dynamicConfiguration.commit();
        RuntimeModelBuilder runtimeModelBuilder = (RuntimeModelBuilder)this.locator.getService(RuntimeModelBuilder.class, new Annotation[0]);
        runtimeModelBuilder.setGlobalInterceptors(readerInterceptors, writerInterceptors);
        runtimeModelBuilder.setBoundProviders(nameBoundRequestFilters, nameBoundResponseFilters, nameBoundReaderInterceptors, nameBoundWriterInterceptors, dynamicFeatures);
        for (Resource resource2 : resourceBag.models) {
            runtimeModelBuilder.process(resource2, false);
        }
        Router resourceRoutingRoot = runtimeModelBuilder.buildModel(false);
        ContainerFilteringStage preMatchRequestFilteringStage = ((ContainerFilteringStage.Builder)this.locator.createAndInitialize(ContainerFilteringStage.Builder.class)).build(preMatchFilters, responseFilters);
        RoutingStage routingStage = ((RoutingStage.Builder)this.locator.createAndInitialize(RoutingStage.Builder.class)).build(resourceRoutingRoot);
        ContainerFilteringStage resourceFilteringStage = ((ContainerFilteringStage.Builder)this.locator.createAndInitialize(ContainerFilteringStage.Builder.class)).build(requestFilters, null);
        RoutedInflectorExtractorStage routedInflectorExtractorStage = (RoutedInflectorExtractorStage)this.locator.createAndInitialize(RoutedInflectorExtractorStage.class);
        Stage rootStage = Stages.chain((Function)((Function)this.locator.createAndInitialize(ReferencesInitializer.class))).to((Function)this.locator.createAndInitialize(ContainerMessageBodyWorkersInitializer.class)).to((ChainableStage)preMatchRequestFilteringStage).to((ChainableStage)routingStage).to((ChainableStage)resourceFilteringStage).build((Stage)routedInflectorExtractorStage);
        for (Object e : providerBag.getInstances()) {
            this.locator.inject(e);
        }
        for (Object object : resourceBag.instances) {
            this.locator.inject(object);
        }
        this.runtime = ((ServerRuntime.Builder)this.locator.createAndInitialize(ServerRuntime.Builder.class)).build((Stage<ContainerRequest>)rootStage);
        this.locator.inject((Object)this);
    }

    private static <T> MultivaluedMap<Class<? extends Annotation>, RankedProvider<T>> filterNameBound(Iterable<RankedProvider<T>> all, Collection<RankedProvider<ContainerRequestFilter>> preMatching, ProviderBag providerBag, Collection<Class<? extends Annotation>> applicationNameBindings) {
        MultivaluedHashMap result = new MultivaluedHashMap();
        Iterator<RankedProvider<T>> it = all.iterator();
        while (it.hasNext()) {
            boolean nameBound;
            RankedProvider<T> provider = it.next();
            Class<?> providerClass = provider.getProvider().getClass();
            ContractProvider model = (ContractProvider)providerBag.getModels().get(providerClass);
            if (model == null) {
                model = ContractProvider.from(providerClass);
            }
            if (preMatching != null && providerClass.getAnnotation(PreMatching.class) != null) {
                it.remove();
                preMatching.add((RankedProvider<ContainerRequestFilter>)new RankedProvider((Object)((ContainerRequestFilter)provider.getProvider()), model.getPriority(ContainerRequestFilter.class)));
            }
            if ((nameBound = model.isNameBound()) && !applicationNameBindings.isEmpty()) {
                for (Class binding : model.getNameBindings()) {
                    if (!applicationNameBindings.contains(binding)) continue;
                    nameBound = false;
                    break;
                }
            }
            if (!nameBound) continue;
            it.remove();
            for (Class binding : model.getNameBindings()) {
                result.add((Object)binding, provider);
            }
        }
        return result;
    }

    private void registerProvidersAndResources(Set<ComponentProvider> componentProviders, ProviderBag providerBag, ResourceBag resourceBag) {
        ContractProvider providerModel;
        JerseyResourceContext resourceContext = (JerseyResourceContext)this.locator.getService(JerseyResourceContext.class, new Annotation[0]);
        DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
        for (Class<?> resourceClass : resourceBag.classes) {
            if (this.bindWithComponentProvider(resourceClass, providerModel = resourceBag.contractProviders.get(resourceClass), componentProviders)) continue;
            if (!Resource.isAcceptable(resourceClass)) {
                LOGGER.warning(LocalizationMessages.NON_INSTANTIABLE_CLASS(resourceClass));
                continue;
            }
            if (providerModel != null && !providerModel.getContracts().isEmpty() && !Providers.checkProviderRuntime(resourceClass, (ConstrainedTo.Type)ConstrainedTo.Type.SERVER, (!this.resourceConfig.getRegisteredClasses().contains(resourceClass) ? 1 : 0) != 0, (boolean)true)) {
                providerModel = null;
            }
            resourceContext.unsafeBindResource(resourceClass, providerModel, dc);
        }
        for (Object resourceInstance : resourceBag.instances) {
            providerModel = resourceBag.contractProviders.get(resourceInstance.getClass());
            if (providerModel != null && !providerModel.getContracts().isEmpty() && !Providers.checkProviderRuntime(resourceInstance.getClass(), (ConstrainedTo.Type)ConstrainedTo.Type.SERVER, (!this.resourceConfig.getRegisteredClasses().contains(resourceInstance.getClass()) ? 1 : 0) != 0, (boolean)true)) {
                providerModel = null;
            }
            resourceContext.unsafeBindResource(resourceInstance, providerModel, dc);
        }
        ProviderBinder.bindProviders((ProviderBag)providerBag, (ConstrainedTo.Type)ConstrainedTo.Type.SERVER, this.resourceConfig.getRegisteredClasses(), (DynamicConfiguration)dc);
        dc.commit();
    }

    private boolean bindWithComponentProvider(Class<?> component, ContractProvider providerModel, Collection<ComponentProvider> componentProviders) {
        Set contracts = providerModel == null ? Collections.emptySet() : providerModel.getContracts();
        for (ComponentProvider provider : componentProviders) {
            if (!provider.bind(component, contracts)) continue;
            return true;
        }
        return false;
    }

    private Application createApplication(Class<? extends Application> applicationClass) {
        if (applicationClass == ResourceConfig.class) {
            return new ResourceConfig();
        }
        if (applicationClass == Application.class) {
            return new Application();
        }
        return (Application)this.locator.createAndInitialize(applicationClass);
    }

    public void registerAdditionalBinders(Set<Binder> binders) {
        DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
        for (Binder binder : binders) {
            binder.bind(dc);
        }
        dc.commit();
    }

    private void validate(List<Resource> resources) {
        BasicValidator validator = new BasicValidator(this.locator);
        for (Resource r : resources) {
            validator.validate(r);
        }
        if (Errors.fatalIssuesFound()) {
            throw new ModelValidationException(ModelErrors.getErrorsAsResourceModelIssues());
        }
    }

    public Future<ContainerResponse> apply(ContainerRequest requestContext) {
        return this.apply(requestContext, new OutputStream(){

            @Override
            public void write(int i) throws IOException {
            }
        });
    }

    public Future<ContainerResponse> apply(ContainerRequest request, OutputStream outputStream) {
        FutureResponseWriter responseFuture = new FutureResponseWriter(request.getMethod(), outputStream);
        request.setSecurityContext(DEFAULT_SECURITY_CONTEXT);
        request.setWriter(responseFuture);
        this.handle(request);
        return responseFuture;
    }

    public void handle(ContainerRequest requestContext) {
        this.runtime.process(requestContext);
    }

    public ServiceLocator getServiceLocator() {
        return this.locator;
    }

    public ResourceConfig getConfiguration() {
        return this.resourceConfig;
    }

    private static class FutureResponseWriter
    extends AbstractFuture<ContainerResponse>
    implements ContainerResponseWriter {
        private static final Logger LOGGER = Logger.getLogger(FutureResponseWriter.class.getName());
        private static final Timer TIMER = new Timer("Jersey application request timer");
        private ContainerResponse response = null;
        private TimerTask timeoutTask = null;
        private ContainerResponseWriter.TimeoutHandler timeoutHandler = null;
        private boolean suspended = false;
        private final Object runtimeLock = new Object();
        private final String requestMethodName;
        private final OutputStream outputStream;

        private FutureResponseWriter(String requestMethodName, OutputStream outputStream) {
            this.requestMethodName = requestMethodName;
            this.outputStream = outputStream;
        }

        @Override
        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse response) throws ContainerException {
            this.response = response;
            if (contentLength >= 0L) {
                response.getHeaders().putSingle((Object)"Content-Length", (Object)Long.toString(contentLength));
            }
            return this.outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean suspend(long time, TimeUnit unit, ContainerResponseWriter.TimeoutHandler handler) throws IllegalStateException {
            Object object = this.runtimeLock;
            synchronized (object) {
                if (this.suspended) {
                    return false;
                }
                this.suspended = true;
                this.timeoutHandler = handler;
                this.setSuspendTimeout(time, unit);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSuspendTimeout(long time, TimeUnit unit) throws IllegalStateException {
            TimerTask task = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = FutureResponseWriter.this.runtimeLock;
                        synchronized (object) {
                            FutureResponseWriter.this.timeoutHandler.onTimeout(FutureResponseWriter.this);
                        }
                    }
                    catch (Throwable throwable) {
                        LOGGER.log(Level.WARNING, LocalizationMessages.SUSPEND_HANDLER_EXECUTION_FAILED(), throwable);
                    }
                }
            };
            Object object = this.runtimeLock;
            synchronized (object) {
                if (!this.suspended) {
                    throw new IllegalStateException(LocalizationMessages.SUSPEND_NOT_SUSPENDED());
                }
                if (this.timeoutTask != null) {
                    this.timeoutTask.cancel();
                    this.timeoutTask = null;
                }
                if (time <= 0L) {
                    return;
                }
                this.timeoutTask = task;
                try {
                    TIMER.schedule(task, unit.toMillis(time));
                }
                catch (IllegalStateException ex) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.SUSPEND_SHEDULING_ERROR(), ex);
                }
            }
        }

        @Override
        public void commit() {
            ContainerResponse current = this.response;
            if (current != null) {
                if ("HEAD".equals(this.requestMethodName) && current.hasEntity()) {
                    current.setEntity(null);
                }
                super.set((Object)current);
            }
        }

        @Override
        public void failure(Throwable error) {
            super.setException(error);
        }

        protected void interruptTask() {
        }
    }

    private class ApplicationBinder
    extends AbstractBinder {
        private ApplicationBinder() {
        }

        protected void configure() {
            this.bindFactory(new ResourceConfigProvider()).to(ResourceConfig.class).to(Configurable.class).in(Singleton.class);
            this.bindFactory(new JaxrsApplicationProvider()).to(Application.class).in(Singleton.class);
            this.bind(ApplicationHandler.this).to(ApplicationHandler.class);
        }

        private class ResourceConfigProvider
        implements Factory<ResourceConfig.RuntimeResourceConfig> {
            private ResourceConfigProvider() {
            }

            public ResourceConfig.RuntimeResourceConfig provide() {
                return ApplicationHandler.this.resourceConfig;
            }

            public void dispose(ResourceConfig.RuntimeResourceConfig instance) {
            }
        }

        private class JaxrsApplicationProvider
        implements Factory<Application> {
            private JaxrsApplicationProvider() {
            }

            public Application provide() {
                return ApplicationHandler.this.application;
            }

            public void dispose(Application instance) {
            }
        }
    }
}

